/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.jdbcproc.plugin.maven;

import com.googlecode.jdbcproc.daofactory.annotation.AStoredProcedure;
import com.googlecode.jdbcproc.daofactory.impl.procedureinfo.StoredProcedureInfo;
import com.payneteasy.jdbcproc.plugin.maven.ClassUtils;
import com.payneteasy.jdbcproc.plugin.maven.FileUtils;
import com.payneteasy.jdbcproc.plugin.maven.ProcedureInfoCreator;
import com.payneteasy.jdbcproc.plugin.maven.ProcedureWriter;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.reflections.Reflections;
import org.reflections.scanners.SubTypesScanner;

@Mojo(name="generate", defaultPhase=LifecyclePhase.COMPILE, requiresDependencyResolution=ResolutionScope.COMPILE, requiresDependencyCollection=ResolutionScope.COMPILE)
public class ProcedureGeneratorMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="username", required=true, readonly=true)
    private String metaLoginUsername;
    @Parameter(defaultValue="role_name", required=true, readonly=true)
    private String metaLoginRoleName;
    @Parameter(defaultValue="target/procedures", required=true, readonly=true)
    private File targetDir;

    public void execute() throws MojoExecutionException, MojoFailureException {
        FileUtils.createDirectories(this.targetDir);
        ClassLoader classLoader = this.getClassLoader();
        Reflections reflections = new Reflections(new Object[]{"", new SubTypesScanner(false), classLoader});
        reflections.getAllTypes().stream().map(name -> this.loadClass(classLoader, (String)name)).filter(this::hasProcedureAnnotation).forEach(this::generateProcedure);
    }

    private void generateProcedure(Class<?> clazz) {
        this.getLog().info((CharSequence)("Generating procedure for class " + clazz));
        ProcedureInfoCreator procedureInfoCreator = new ProcedureInfoCreator(this.metaLoginUsername, this.metaLoginRoleName);
        File packageDir = FileUtils.createDirectories(new File(this.targetDir, ClassUtils.getLastPackageName(clazz)));
        List<StoredProcedureInfo> procedures = procedureInfoCreator.createProcedures(clazz);
        for (StoredProcedureInfo procedure : procedures) {
            File file = new File(packageDir, procedure.getProcedureName() + ".prc");
            this.getLog().info((CharSequence)String.format("    Writing %s() to %s ...", procedure.getProcedureName(), file.getAbsolutePath()));
            try {
                ProcedureWriter writer = new ProcedureWriter(file);
                writer.write(procedure);
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot write " + file.getAbsolutePath(), e);
            }
        }
    }

    private boolean hasProcedureAnnotation(Class<?> clazz) {
        for (Method method : ClassUtils.getAllMethods(clazz)) {
            if (!method.isAnnotationPresent(AStoredProcedure.class)) continue;
            return true;
        }
        return false;
    }

    private Class<?> loadClass(ClassLoader classLoader, String name) {
        try {
            return classLoader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Cannot load class " + name, e);
        }
    }

    private ClassLoader getClassLoader() {
        List runtimeClasspathElements = null;
        try {
            runtimeClasspathElements = this.project.getRuntimeClasspathElements();
        }
        catch (DependencyResolutionRequiredException e) {
            throw new IllegalStateException("Failed to resolve runtime classpath elements");
        }
        URL[] runtimeUrls = new URL[runtimeClasspathElements.size()];
        for (int i = 0; i < runtimeClasspathElements.size(); ++i) {
            String element = (String)runtimeClasspathElements.get(i);
            try {
                runtimeUrls[i] = new File(element).toURI().toURL();
                continue;
            }
            catch (MalformedURLException e) {
                this.getLog().error((CharSequence)"Failed to resolve runtime classpath element", (Throwable)e);
            }
        }
        return new URLClassLoader(runtimeUrls, Thread.currentThread().getContextClassLoader());
    }
}

