/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.dns8;

import com.payneteasy.dns8.support.HostsCache;
import com.payneteasy.dns8.support.HostsFile;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Optional;
import java.util.ServiceConfigurationError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.net.spi.nameservice.NameService;

public class Dns8NameService
implements NameService {
    private static final Logger LOG = LoggerFactory.getLogger(Dns8NameService.class);
    private final HostsCache hostsCache;

    public Dns8NameService() {
        String hostsFilename = System.getenv("HOSTS_FILE");
        if (HostsFile.isEmpty(hostsFilename)) {
            throw new ServiceConfigurationError("No env variable HOSTS_FILE");
        }
        LOG.info("Loading hosts from file {}", (Object)hostsFilename);
        this.hostsCache = new HostsCache(new File(hostsFilename));
        this.hostsCache.dump(LOG);
    }

    public InetAddress[] lookupAllHostAddr(String aHost) throws UnknownHostException {
        Optional<InetAddress[]> addresses = this.hostsCache.findHostAddresses(aHost);
        if (addresses.isPresent()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found {} for {}", (Object)aHost, Arrays.asList((Object[])addresses.get()));
            }
            return addresses.get();
        }
        LOG.debug("Not found {}", (Object)aHost);
        throw new UnknownHostException(aHost);
    }

    public String getHostByAddr(byte[] addr) throws UnknownHostException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("getHostByAddr: {}", (Object)Dns8NameService.toIpAddress(addr));
        }
        throw new UnknownHostException();
    }

    private static String toIpAddress(byte[] addr) {
        StringBuilder sb = new StringBuilder();
        if (addr != null) {
            for (byte b : addr) {
                sb.append(".");
                sb.append(b);
            }
        }
        return sb.toString();
    }
}

