/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.dns8.support;

import com.payneteasy.dns8.support.HostAddresses;
import com.payneteasy.dns8.support.HostsFile;
import java.io.File;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostsCache {
    private static final Logger LOG = LoggerFactory.getLogger(HostsCache.class);
    private final Map<String, InetAddress[]> addresses;

    public HostsCache(File aFile) {
        this.addresses = new HostAddresses(HostsFile.loadHostsFile(aFile)).toMap();
    }

    public Optional<InetAddress[]> findHostAddresses(String aName) {
        return Optional.ofNullable(this.addresses.get(aName));
    }

    public void dump() {
        LOG.info("Addresses:");
        for (Map.Entry<String, InetAddress[]> entry : this.addresses.entrySet()) {
            LOG.info("  {} = {}", (Object)entry.getKey(), Arrays.asList((Object[])entry.getValue()));
        }
    }
}

