/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.dns8.support;

import com.payneteasy.dns8.support.HostAddress;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class HostAddresses {
    private final Map<String, List<InetAddress>> addresses;

    public HostAddresses(List<HostAddress> aList) {
        this.addresses = HostAddresses.toAddresses(aList);
    }

    private static Map<String, List<InetAddress>> toAddresses(List<HostAddress> aList) {
        HashMap<String, List<InetAddress>> map = new HashMap<String, List<InetAddress>>();
        for (HostAddress hostAddress : aList) {
            List inetAddresses = map.computeIfAbsent(hostAddress.getHost(), k -> new ArrayList());
            inetAddresses.add(hostAddress.getInetAddress());
        }
        return map;
    }

    public Map<String, InetAddress[]> toMap() {
        return this.addresses.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((List)e.getValue()).toArray(new InetAddress[0])));
    }
}

