/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.dns8.support;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ServiceConfigurationError;
import java.util.StringTokenizer;

public class HostAddress {
    private final String host;
    private final String address;

    public InetAddress getInetAddress() {
        try {
            return Inet4Address.getByAddress(this.ipToBytes(this.address));
        }
        catch (UnknownHostException e) {
            throw new ServiceConfigurationError("Cannot parse ip address " + this.address);
        }
    }

    private byte[] ipToBytes(String aIp) {
        StringTokenizer st = new StringTokenizer(aIp, ".");
        byte[] buf = new byte[]{HostAddress.nextByte(st), HostAddress.nextByte(st), HostAddress.nextByte(st), HostAddress.nextByte(st)};
        return buf;
    }

    private static byte nextByte(StringTokenizer st) {
        return (byte)Integer.parseInt(st.nextToken());
    }

    HostAddress(String host, String address) {
        this.host = host;
        this.address = address;
    }

    public static HostAddressBuilder builder() {
        return new HostAddressBuilder();
    }

    public String getHost() {
        return this.host;
    }

    public String getAddress() {
        return this.address;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HostAddress)) {
            return false;
        }
        HostAddress other = (HostAddress)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        return !(this$address == null ? other$address != null : !this$address.equals(other$address));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HostAddress;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        return result;
    }

    public String toString() {
        return "HostAddress(host=" + this.getHost() + ", address=" + this.getAddress() + ")";
    }

    public static class HostAddressBuilder {
        private String host;
        private String address;

        HostAddressBuilder() {
        }

        public HostAddressBuilder host(String host) {
            this.host = host;
            return this;
        }

        public HostAddressBuilder address(String address) {
            this.address = address;
            return this;
        }

        public HostAddress build() {
            return new HostAddress(this.host, this.address);
        }

        public String toString() {
            return "HostAddress.HostAddressBuilder(host=" + this.host + ", address=" + this.address + ")";
        }
    }
}

