/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.http.server.impl.response;

import com.payneteasy.http.server.api.response.HttpResponse;
import com.payneteasy.http.server.api.response.HttpResponseHeader;
import com.payneteasy.http.server.api.response.HttpResponseHeaders;
import com.payneteasy.http.server.api.response.HttpResponseMessageBody;
import com.payneteasy.http.server.api.response.HttpResponseStatusLine;
import java.util.ArrayList;
import java.util.List;

public class HttpResponseBuilder {
    private final HttpResponseStatusLine statusLine;
    private final List<HttpResponseHeader> headers = new ArrayList<HttpResponseHeader>();
    private HttpResponseMessageBody body;

    private HttpResponseBuilder(HttpResponseStatusLine statusLine) {
        this.statusLine = statusLine;
    }

    public static HttpResponseBuilder statusOk() {
        return new HttpResponseBuilder(HttpResponseStatusLine.OK);
    }

    public static HttpResponseBuilder status(HttpResponseStatusLine aStatus) {
        return new HttpResponseBuilder(aStatus);
    }

    public HttpResponseBuilder body(HttpResponseMessageBody aBody) {
        this.body = aBody;
        return this;
    }

    public HttpResponseBuilder body(byte[] aBytes) {
        this.body = new HttpResponseMessageBody(aBytes);
        return this;
    }

    public HttpResponseBuilder addHeader(String aName, String aValue) {
        this.headers.add(new HttpResponseHeader(aName, aValue));
        return this;
    }

    public HttpResponseBuilder addHeader(String aName, int aValue) {
        this.headers.add(new HttpResponseHeader(aName, String.valueOf(aValue)));
        return this;
    }

    public HttpResponse build() {
        this.addHeader("Content-Length", this.body.getBytes().length);
        return new HttpResponse(this.statusLine, new HttpResponseHeaders(this.headers), this.body);
    }
}

