/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.http.server.impl.response;

import com.payneteasy.http.server.api.response.HttpResponseHeader;
import com.payneteasy.http.server.api.response.HttpResponseHeaders;
import com.payneteasy.http.server.api.response.HttpResponseMessageBody;
import com.payneteasy.http.server.api.response.HttpResponseStatusLine;
import com.payneteasy.http.server.impl.response.IHttpResponseStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;

public class HttpResponseStreamImpl
implements IHttpResponseStream {
    private static final byte[] HTTP_1_1 = "HTTP/1.1".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] SP = " ".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] CRLF = "\r\n".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] COLON = ": ".getBytes(StandardCharsets.US_ASCII);
    private final OutputStream out;

    public HttpResponseStreamImpl(OutputStream aOut) {
        this.out = aOut;
    }

    @Override
    public void writeStatusLine(HttpResponseStatusLine aStatusLine) throws IOException {
        this.out.write(HTTP_1_1);
        this.out.write(SP);
        this.out.write(aStatusLine.getStatusCodeAsBytes());
        this.out.write(SP);
        this.out.write(aStatusLine.getReasonPhraseAsBytes());
        this.out.write(CRLF);
        this.out.flush();
    }

    @Override
    public void writeHeaders(HttpResponseHeaders aHeaders, HttpResponseMessageBody body) throws IOException {
        for (HttpResponseHeader header : aHeaders.getHeaders()) {
            this.writeHeader(header);
        }
        if (body.getBytes() != null && body.getBytes().length > 0) {
            this.writeHeader(new HttpResponseHeader("Content-Length", String.valueOf(body.getBytes().length)));
        }
        this.writeHeader(new HttpResponseHeader("Connection", "Close"));
        this.out.write(CRLF);
        this.out.flush();
    }

    private void writeHeader(HttpResponseHeader header) throws IOException {
        this.out.write(header.getName().getBytes(StandardCharsets.US_ASCII));
        this.out.write(COLON);
        this.out.write(header.getValue().getBytes(StandardCharsets.US_ASCII));
        this.out.write(CRLF);
    }

    @Override
    public void writeBody(HttpResponseMessageBody aBody) throws IOException {
        this.out.write(aBody.getBytes());
        this.out.flush();
    }
}

