/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.http.server.impl.request;

import com.payneteasy.http.server.api.request.HttpRequestHeader;
import com.payneteasy.http.server.api.request.HttpRequestHeaders;
import com.payneteasy.http.server.impl.request.IHttpInputStream;
import com.payneteasy.http.server.log.IHttpLogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class HttpRequestHeadersParser {
    private final IHttpLogger logger;

    public HttpRequestHeadersParser(IHttpLogger aLogger) {
        this.logger = aLogger;
    }

    public HttpRequestHeaders parseHeaders(IHttpInputStream aStream) throws IOException {
        return new HttpRequestHeaders(this.parseHeadersToList(aStream));
    }

    private List<HttpRequestHeader> parseHeadersToList(IHttpInputStream aInput) throws IOException {
        HttpRequestHeader header;
        ArrayList<HttpRequestHeader> headers = new ArrayList<HttpRequestHeader>();
        while ((header = this.parseHeader(aInput)) != null) {
            headers.add(header);
        }
        return headers;
    }

    private HttpRequestHeader parseHeader(IHttpInputStream aInput) throws IOException {
        String name = aInput.readerUntilColonOrCrlf();
        if (name == null) {
            return null;
        }
        String value = aInput.readUntilCrlf();
        return new HttpRequestHeader(name.trim(), value.trim());
    }
}

