/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.http.server.impl;

import com.payneteasy.http.server.api.handler.IHttpRequestHandler;
import com.payneteasy.http.server.api.request.HttpRequest;
import com.payneteasy.http.server.api.request.HttpRequestHeaders;
import com.payneteasy.http.server.api.request.HttpRequestLine;
import com.payneteasy.http.server.api.request.HttpRequestMessageBody;
import com.payneteasy.http.server.api.response.HttpResponse;
import com.payneteasy.http.server.impl.request.HttpInputStreamImpl;
import com.payneteasy.http.server.impl.request.HttpRequestHeadersParser;
import com.payneteasy.http.server.impl.request.HttpRequestLineParser;
import com.payneteasy.http.server.impl.request.HttpRequestMessageBodyParser;
import com.payneteasy.http.server.impl.response.HttpResponseStreamImpl;
import com.payneteasy.http.server.log.IHttpLogger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;

public class HttpClientTask
implements Runnable {
    private final Socket socket;
    private final IHttpLogger logger;
    private final HttpRequestLineParser requestLineParser;
    private final HttpRequestHeadersParser requestHeadersParser;
    private final HttpRequestMessageBodyParser requestBodyParser;
    private final IHttpRequestHandler requestHandler;

    public HttpClientTask(Socket aSocket, IHttpLogger aLogger, IHttpRequestHandler aHandler) {
        this.socket = aSocket;
        this.logger = aLogger;
        this.requestLineParser = new HttpRequestLineParser(aLogger);
        this.requestHeadersParser = new HttpRequestHeadersParser(aLogger);
        this.requestBodyParser = new HttpRequestMessageBodyParser(aLogger);
        this.requestHandler = aHandler;
    }

    @Override
    public void run() {
        try {
            this.processStreams(this.socket.getInputStream(), this.socket.getOutputStream(), (InetSocketAddress)this.socket.getRemoteSocketAddress());
        }
        catch (Exception e) {
            this.logger.error("Error while processing client", e);
        }
        finally {
            this.closeSocket();
        }
    }

    private void processStreams(InputStream aIn, OutputStream aOut, InetSocketAddress aAddress) throws IOException {
        HttpInputStreamImpl httpInputStream = new HttpInputStreamImpl(aIn);
        HttpRequestLine requestLine = this.requestLineParser.parseRequestLine(httpInputStream);
        HttpRequestHeaders requestHeaders = this.requestHeadersParser.parseHeaders(httpInputStream);
        HttpRequestMessageBody requestBody = this.requestBodyParser.parseMessageBody(httpInputStream, requestHeaders);
        HttpRequest request = new HttpRequest(requestLine, requestHeaders, requestBody, aAddress);
        this.logger.debug("Request", "line", requestLine, "headers", requestHeaders, "body", requestBody);
        HttpResponse response = this.requestHandler.handleRequest(request);
        HttpResponseStreamImpl responseStream = new HttpResponseStreamImpl(aOut);
        responseStream.writeStatusLine(response.getStatusLine());
        responseStream.writeHeaders(response.getHeaders(), response.getBody());
        responseStream.writeBody(response.getBody());
        this.logger.debug("Wrote response", "status", response.getStatusLine(), "headers", response.getHeaders(), "body", response.getBody());
    }

    private void closeSocket() {
        this.logger.debug("Closing connection", new Object[0]);
        try {
            this.socket.close();
        }
        catch (IOException e) {
            this.logger.error("Cannot close socket", e);
        }
    }
}

