/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.http.server;

import com.payneteasy.http.server.api.handler.IHttpRequestHandler;
import com.payneteasy.http.server.impl.HttpClientTask;
import com.payneteasy.http.server.log.IHttpLogger;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;

public class HttpServer {
    private final ServerSocket serverSocket;
    private final AtomicBoolean isRunning = new AtomicBoolean(true);
    private final IHttpLogger log;
    private final ExecutorService executorService;
    private final IHttpRequestHandler handler;
    private final int readTimeoutMs;

    public HttpServer(InetSocketAddress aBindAddress, IHttpLogger aLog, ExecutorService aExecutor, IHttpRequestHandler aHandler, int aReadTimeoutMs) throws IOException {
        this.log = aLog;
        this.executorService = aExecutor;
        this.handler = aHandler;
        this.readTimeoutMs = aReadTimeoutMs;
        this.serverSocket = new ServerSocket();
        this.serverSocket.setReuseAddress(true);
        this.serverSocket.bind(aBindAddress);
    }

    public void acceptSocketAndWait() {
        this.log.debug("Start listening...", "serverSocket", this.serverSocket);
        while (!Thread.currentThread().isInterrupted() && this.isRunning.get()) {
            try {
                Socket clientSocket = this.serverSocket.accept();
                clientSocket.setSoTimeout(this.readTimeoutMs);
                clientSocket.setTcpNoDelay(true);
                this.log.debug("Connected from client", "remote address", clientSocket.getRemoteSocketAddress());
                this.executorService.execute(new HttpClientTask(clientSocket, this.log, this.handler));
            }
            catch (Exception e) {
                if (Thread.currentThread().isInterrupted() || !this.isRunning.get()) {
                    this.log.error("Exiting from the listening server socket ...");
                    break;
                }
                this.log.error("Cannot deal with socket", e);
            }
        }
        this.log.debug("Exited from accept loop.", new Object[0]);
    }

    public void stop() {
        this.log.debug("Stopping ...", new Object[0]);
        this.isRunning.set(false);
        try {
            this.serverSocket.close();
        }
        catch (Exception e) {
            this.log.error("Cannot close server socket", e);
        }
    }
}

