/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.http.server.api.request;

import com.payneteasy.http.server.api.request.HttpRequestHeader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HttpRequestHeaders {
    private final Map<String, String> headers;

    public HttpRequestHeaders(List<HttpRequestHeader> aHeaders) {
        this.headers = new HashMap<String, String>(aHeaders.size());
        for (HttpRequestHeader header : aHeaders) {
            this.headers.put(header.getName().toLowerCase(), header.getValue());
        }
    }

    public int getContentLength() {
        return this.getRequiredInt("content-length");
    }

    public String getString(String aName) {
        return this.headers.get(this.normalizeName(aName));
    }

    public String getRequiredString(String aName) {
        String value = this.headers.get(this.normalizeName(aName));
        if (value == null) {
            throw new IllegalStateException("Header " + aName + " not found");
        }
        return value;
    }

    public int getRequiredInt(String aName) {
        return Integer.parseInt(this.getRequiredString(aName));
    }

    private String normalizeName(String aName) {
        return aName.toLowerCase();
    }

    public String toString() {
        return "HttpRequestHeaders{headers=" + this.headers + '}';
    }
}

