/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.http.server.api.response;

import java.nio.charset.StandardCharsets;

public class HttpResponseStatusLine {
    public static final HttpResponseStatusLine OK = new HttpResponseStatusLine(200, "OK");
    public static final HttpResponseStatusLine BAD_REQUEST = new HttpResponseStatusLine(400, "Bad Request");
    private final int statusCode;
    private final String reasonPhrase;
    private final byte[] statusCodeBytes;
    private final byte[] reasonPhraseBytes;

    public HttpResponseStatusLine(int statusCode, String reasonPhrase) {
        this.statusCode = statusCode;
        this.reasonPhrase = reasonPhrase;
        this.statusCodeBytes = ("" + statusCode).getBytes(StandardCharsets.US_ASCII);
        this.reasonPhraseBytes = reasonPhrase.getBytes(StandardCharsets.US_ASCII);
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getReasonPhrase() {
        return this.reasonPhrase;
    }

    public byte[] getStatusCodeAsBytes() {
        return this.statusCodeBytes;
    }

    public byte[] getReasonPhraseAsBytes() {
        return this.reasonPhraseBytes;
    }

    public String toString() {
        return "HTTP/1.1 " + this.statusCode + " " + this.reasonPhrase;
    }
}

