/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.http.client.okhttp;

import com.payneteasy.http.client.api.HttpHeader;
import com.payneteasy.http.client.api.HttpHeaders;
import com.payneteasy.http.client.api.HttpProxyParameters;
import com.payneteasy.http.client.api.HttpRequest;
import com.payneteasy.http.client.api.HttpRequestParameters;
import com.payneteasy.http.client.api.HttpResponse;
import com.payneteasy.http.client.api.HttpTimeouts;
import com.payneteasy.http.client.api.IHttpClient;
import com.payneteasy.http.client.api.exceptions.HttpConnectException;
import com.payneteasy.http.client.api.exceptions.HttpProxyAuthConnectionException;
import com.payneteasy.http.client.api.exceptions.HttpReadException;
import com.payneteasy.http.client.api.exceptions.HttpWriteException;
import com.payneteasy.http.client.okhttp.ProxyAuthenticator;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import kotlin.Pair;
import lombok.NonNull;
import okhttp3.Authenticator;
import okhttp3.Call;
import okhttp3.ConnectionPool;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.Util;
import org.jetbrains.annotations.NotNull;

public class HttpClientOkHttpImpl
implements IHttpClient {
    private final OkHttpClient defaultClient;

    public HttpClientOkHttpImpl() {
        this(new OkHttpClient.Builder().connectionPool(new ConnectionPool()).build());
    }

    public HttpClientOkHttpImpl(OkHttpClient aDefaultClient) {
        this.defaultClient = aDefaultClient;
    }

    public HttpResponse send(HttpRequest aRequest, HttpRequestParameters aRequestParameters) throws HttpConnectException, HttpReadException, HttpWriteException {
        Request request = this.createRequest(aRequest);
        OkHttpClient client = this.createClient(aRequestParameters);
        Call call = client.newCall(request);
        String url = aRequest.getUrl();
        Response response = this.executeCall(call, url);
        return this.createResponse(response);
    }

    @NotNull
    private Response executeCall(Call call, @NonNull String url) throws HttpConnectException, HttpReadException {
        Response response;
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        long starTimeMs = System.currentTimeMillis();
        try {
            response = call.execute();
        }
        catch (SSLHandshakeException | SSLPeerUnverifiedException e) {
            throw new HttpConnectException("Bad ssl certificate at " + url, (Throwable)e);
        }
        catch (ProtocolException e) {
            if ("Unexpected status line: <html><head><title>407 Proxy Authentication Required</title></head>".equals(e.getMessage())) {
                throw new HttpConnectException("407 Proxy Authentication Required", (Throwable)e);
            }
            throw new HttpConnectException("Protocol error: cannot connect to " + url + " within " + (System.currentTimeMillis() - starTimeMs) + " ms", (Throwable)e);
        }
        catch (ConnectException e) {
            throw new HttpConnectException("Cannot connect to " + url + " within " + (System.currentTimeMillis() - starTimeMs) + " ms", (Throwable)e);
        }
        catch (SocketTimeoutException e) {
            throw new HttpConnectException("Connection timed out to " + url + " within " + (System.currentTimeMillis() - starTimeMs) + " ms", (Throwable)e);
        }
        catch (InterruptedIOException e) {
            throw new HttpConnectException("Connection interrupted to " + url + " within " + (System.currentTimeMillis() - starTimeMs) + " ms", (Throwable)e);
        }
        catch (IOException e) {
            if ("Failed to authenticate with proxy".equals(e.getMessage())) {
                throw new HttpProxyAuthConnectionException("Failed to authenticate with proxy", (Throwable)e);
            }
            throw new HttpReadException("Cannot read from " + url, (Throwable)e);
        }
        return response;
    }

    @NotNull
    private HttpResponse createResponse(Response aResponse) throws HttpReadException {
        byte[] bytes;
        ResponseBody body = aResponse.body();
        try {
            bytes = body != null ? body.bytes() : new byte[]{};
        }
        catch (IOException e) {
            throw new HttpReadException("Cannot read byte", (Throwable)e);
        }
        return new HttpResponse(aResponse.code(), aResponse.message(), this.convertHeaders(aResponse), bytes);
    }

    @NotNull
    private List<HttpHeader> convertHeaders(Response aResponse) {
        Headers headers = aResponse.headers();
        ArrayList<HttpHeader> list = new ArrayList<HttpHeader>();
        for (Pair header : headers) {
            list.add(new HttpHeader((String)header.getFirst(), (String)header.getSecond()));
        }
        return list;
    }

    @NotNull
    private Request createRequest(HttpRequest aRequest) {
        Request.Builder builder = new Request.Builder().url(aRequest.getUrl()).headers(this.createHeaders(aRequest.getHeaders()));
        if (aRequest.getBody() != null && aRequest.getBody().length > 0) {
            builder.method(aRequest.getMethod().name(), RequestBody.create((byte[])aRequest.getBody()));
        } else {
            builder.method(aRequest.getMethod().name(), null);
        }
        return builder.build();
    }

    @NotNull
    private OkHttpClient createClient(HttpRequestParameters aRequestParameters) {
        HttpTimeouts timeouts = aRequestParameters.getTimeouts();
        HttpProxyParameters proxyParameters = aRequestParameters.getProxyParameters();
        OkHttpClient.Builder builder = this.defaultClient.newBuilder().connectTimeout((long)timeouts.getConnectTimeoutMs(), TimeUnit.MILLISECONDS).readTimeout((long)timeouts.getReadTimeoutMs(), TimeUnit.MILLISECONDS).callTimeout((long)timeouts.getCallTimeoutMs(), TimeUnit.MILLISECONDS).writeTimeout((long)timeouts.getWriteTimeoutMs(), TimeUnit.MILLISECONDS);
        if (proxyParameters == null || proxyParameters.getProxy() == null) {
            return builder.build();
        }
        builder.proxy(proxyParameters.getProxy());
        if (proxyParameters.getProxyUsername() == null) {
            return builder.build();
        }
        builder.proxyAuthenticator((Authenticator)new ProxyAuthenticator(proxyParameters.getProxyUsername(), proxyParameters.getProxyPassword()));
        return builder.build();
    }

    private Headers createHeaders(HttpHeaders aRequestHeaders) {
        if (aRequestHeaders == null) {
            return Util.EMPTY_HEADERS;
        }
        List list = aRequestHeaders.asList();
        HashMap<String, String> map = new HashMap<String, String>();
        for (HttpHeader header : list) {
            map.put(header.getName(), header.getValue());
        }
        return Headers.of(map);
    }
}

