/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.http.client.okhttp;

import java.io.IOException;
import okhttp3.Authenticator;
import okhttp3.Challenge;
import okhttp3.Credentials;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProxyAuthenticator
implements Authenticator {
    private final String username;
    private final String password;

    public ProxyAuthenticator(String username, String password) {
        this.username = username;
        this.password = password;
    }

    @Nullable
    public Request authenticate(@Nullable Route aRoute, @NotNull Response aResponse) throws IOException {
        if (aResponse.request().header("Proxy-Authorization") != null) {
            return null;
        }
        String credential = Credentials.basic((String)this.username, (String)this.password);
        for (Challenge challenge : aResponse.challenges()) {
            if (!challenge.scheme().equalsIgnoreCase("OkHttp-Preemptive")) continue;
            return aResponse.request().newBuilder().header("Proxy-Authorization", credential).build();
        }
        return aResponse.request().newBuilder().header("Proxy-Authorization", credential).build();
    }
}

