/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.http.client.impl;

import com.payneteasy.http.client.api.HttpHeader;
import com.payneteasy.http.client.api.HttpHeaders;
import com.payneteasy.http.client.api.HttpTimeouts;
import com.payneteasy.http.client.api.exceptions.HttpConnectException;
import com.payneteasy.http.client.api.exceptions.HttpReadException;
import com.payneteasy.http.client.api.exceptions.HttpWriteException;
import com.payneteasy.http.client.impl.HttpHeaderFinder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.net.ssl.SSLHandshakeException;

public class SafeHttpURLConnection {
    private static final Logger LOG = Logger.getLogger("http-client.HttpClientImpl");
    private final HttpURLConnection aConnection;

    public SafeHttpURLConnection(HttpURLConnection connection) {
        this.aConnection = connection;
    }

    public void sendHeaders(HttpHeaders aHeaders) {
        if (aHeaders == null) {
            return;
        }
        for (HttpHeader header : aHeaders.asList()) {
            this.aConnection.setRequestProperty(header.getName(), header.getValue());
        }
    }

    public void sendBody(String aUrl, byte[] aRequestBody) throws HttpWriteException {
        OutputStream outputStream;
        if (aRequestBody == null || aRequestBody.length == 0) {
            return;
        }
        this.aConnection.setDoOutput(true);
        try {
            outputStream = this.aConnection.getOutputStream();
        }
        catch (IOException e) {
            throw new HttpWriteException("Cannot create output stream for url " + aUrl, (Throwable)e);
        }
        try {
            outputStream.write(aRequestBody);
        }
        catch (IOException e) {
            throw new HttpWriteException("Cannot create write body to url " + aUrl, (Throwable)e);
        }
    }

    public int waitForStatusCode(String aUrl, HttpTimeouts aTimeouts) throws HttpReadException, HttpConnectException {
        int statusCode;
        LOG.fine(String.format("Waiting for response code for %s with timeouts %s ...", aUrl, aTimeouts.toString()));
        try {
            statusCode = this.aConnection.getResponseCode();
        }
        catch (SSLHandshakeException e) {
            throw new HttpConnectException("Bad ssl certificate at " + aUrl, (Throwable)e);
        }
        catch (ConnectException e) {
            throw new HttpConnectException("Cannot connect to " + aUrl, (Throwable)e);
        }
        catch (IOException e) {
            throw new HttpReadException("Cannot wait for response code for url " + aUrl, (Throwable)e);
        }
        return statusCode;
    }

    public String readReasonPhrase(String aUrl) throws HttpReadException {
        try {
            return this.aConnection.getResponseMessage();
        }
        catch (IOException e) {
            throw new HttpReadException("Cannot read reason phrase for url " + aUrl, (Throwable)e);
        }
    }

    public List<HttpHeader> readHeaders() {
        Map<String, List<String>> headerFields = this.aConnection.getHeaderFields();
        ArrayList<HttpHeader> headers = new ArrayList<HttpHeader>(headerFields.size());
        for (Map.Entry<String, List<String>> entry : headerFields.entrySet()) {
            String name;
            if (entry == null || (name = entry.getKey()) == null) continue;
            List<String> values = entry.getValue();
            if (values == null) {
                headers.add(new HttpHeader(name, ""));
                continue;
            }
            for (String value : values) {
                headers.add(new HttpHeader(name, value));
            }
        }
        return Collections.unmodifiableList(headers);
    }

    @Nonnull
    public InputStream getInputStream(String aUrl, int aStatusCode, List<HttpHeader> aHeaders) throws HttpReadException {
        try {
            InputStream inputStream;
            InputStream inputStream2 = inputStream = aStatusCode >= 400 ? this.aConnection.getErrorStream() : this.aConnection.getInputStream();
            if (inputStream != null && this.hasContent(aHeaders)) {
                return inputStream;
            }
            return new ByteArrayInputStream(new byte[0]);
        }
        catch (IOException e) {
            throw new HttpReadException("Cannot create input stream for url " + aUrl, (Throwable)e);
        }
    }

    public void disconnect() {
        this.aConnection.disconnect();
    }

    private boolean hasContent(List<HttpHeader> aHeaders) {
        int length = this.aConnection.getContentLength();
        if (length > 0) {
            return true;
        }
        HttpHeaderFinder headerFinder = new HttpHeaderFinder(aHeaders);
        String transferEncoding = headerFinder.get("Transfer-Encoding");
        if (transferEncoding == null) {
            return false;
        }
        return transferEncoding.contains("chunked");
    }
}

