/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.http.client.impl;

import com.payneteasy.http.client.api.HttpHeader;
import com.payneteasy.http.client.api.HttpMethod;
import com.payneteasy.http.client.api.HttpProxyParameters;
import com.payneteasy.http.client.api.HttpRequest;
import com.payneteasy.http.client.api.HttpRequestParameters;
import com.payneteasy.http.client.api.HttpTimeouts;
import com.payneteasy.http.client.api.IHttpStreamClient;
import com.payneteasy.http.client.api.IHttpStreamResponse;
import com.payneteasy.http.client.api.IHttpStreamResponseListener;
import com.payneteasy.http.client.api.exceptions.HttpConnectException;
import com.payneteasy.http.client.api.exceptions.HttpReadException;
import com.payneteasy.http.client.api.exceptions.HttpWriteException;
import com.payneteasy.http.client.impl.HttpStreamResponseImpl;
import com.payneteasy.http.client.impl.LocalThreadProxyAuthenticator;
import com.payneteasy.http.client.impl.SafeHttpURLConnection;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public class HttpStreamClientImpl
implements IHttpStreamClient {
    private static final Logger LOG = Logger.getLogger("http-client.HttpClientImpl");

    public static void registerGlobalProxyAuthenticator() {
        System.getProperties().put("jdk.http.auth.tunneling.disabledSchemes", "");
        System.getProperties().put("sun.net.client.defaultReadTimeout", "60000");
        System.getProperties().put("sun.net.client.defaultConnectTimeout", "20000");
        Authenticator.setDefault(new LocalThreadProxyAuthenticator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(HttpRequest aRequest, HttpRequestParameters aRequestParameters, IHttpStreamResponseListener aListener) throws HttpConnectException, HttpReadException, HttpWriteException {
        HttpProxyParameters proxyParameters = HttpStreamClientImpl.configureProxyParameters(aRequestParameters);
        try {
            String url = aRequest.getUrl();
            SafeHttpURLConnection connection = new SafeHttpURLConnection(this.createConnection(url, aRequest.getMethod(), aRequestParameters));
            connection.sendHeaders(aRequest.getHeaders());
            connection.sendBody(url, aRequest.getBody());
            this.parseListenerResponse(aListener, url, connection, aRequestParameters.getTimeouts());
        }
        finally {
            HttpStreamClientImpl.clearProxyParameters(proxyParameters);
        }
    }

    private static void clearProxyParameters(@Nullable HttpProxyParameters proxyParameters) {
        if (proxyParameters != null) {
            LocalThreadProxyAuthenticator.clear();
        }
    }

    @Nullable
    private static HttpProxyParameters configureProxyParameters(HttpRequestParameters aRequestParameters) {
        HttpProxyParameters proxyParameters = aRequestParameters.getProxyParameters();
        if (proxyParameters != null) {
            LocalThreadProxyAuthenticator.setParameters(proxyParameters);
        }
        return proxyParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IHttpStreamResponse send(HttpRequest aRequest, HttpRequestParameters aRequestParameters) throws HttpConnectException, HttpReadException, HttpWriteException {
        HttpProxyParameters proxyParameters = HttpStreamClientImpl.configureProxyParameters(aRequestParameters);
        try {
            String url = aRequest.getUrl();
            SafeHttpURLConnection connection = new SafeHttpURLConnection(this.createConnection(url, aRequest.getMethod(), aRequestParameters));
            connection.sendHeaders(aRequest.getHeaders());
            connection.sendBody(url, aRequest.getBody());
            IHttpStreamResponse iHttpStreamResponse = this.parseListenerResponse(url, connection, aRequestParameters.getTimeouts());
            return iHttpStreamResponse;
        }
        finally {
            HttpStreamClientImpl.clearProxyParameters(proxyParameters);
        }
    }

    private void parseListenerResponse(IHttpStreamResponseListener aListener, String aUrl, SafeHttpURLConnection aConnection, HttpTimeouts aTimeouts) throws HttpReadException, HttpConnectException {
        int statusCode = aConnection.waitForStatusCode(aUrl, aTimeouts);
        String reasonPhrase = aConnection.readReasonPhrase(aUrl);
        aListener.onStatus(statusCode, reasonPhrase);
        List<HttpHeader> headers = aConnection.readHeaders();
        aListener.onHeaders(headers);
        this.readMessageBody(aListener, aUrl, statusCode, aConnection, headers);
    }

    private IHttpStreamResponse parseListenerResponse(String aUrl, SafeHttpURLConnection aConnection, HttpTimeouts aTimeouts) throws HttpReadException, HttpConnectException {
        int statusCode = aConnection.waitForStatusCode(aUrl, aTimeouts);
        String reasonPhrase = aConnection.readReasonPhrase(aUrl);
        List<HttpHeader> headers = aConnection.readHeaders();
        InputStream inputStream = aConnection.getInputStream(aUrl, statusCode, headers);
        return new HttpStreamResponseImpl(statusCode, reasonPhrase, headers, inputStream, aConnection);
    }

    private void readMessageBody(IHttpStreamResponseListener aListener, String aUrl, int aStatusCode, SafeHttpURLConnection aConnection, List<HttpHeader> aHeaders) throws HttpReadException {
        InputStream inputStream = aConnection.getInputStream(aUrl, aStatusCode, aHeaders);
        try {
            HttpStreamClientImpl.readAllBytes(aListener, inputStream);
        }
        catch (IOException e) {
            throw new HttpReadException("Cannot read message body from " + aUrl, (Throwable)e);
        }
    }

    private HttpURLConnection createConnection(String aUrl, HttpMethod aMethod, HttpRequestParameters aParameters) throws HttpConnectException {
        HttpURLConnection connection;
        URL url;
        try {
            url = new URL(aUrl);
        }
        catch (MalformedURLException e) {
            throw new HttpConnectException("Cannot parse url: " + aUrl, (Throwable)e);
        }
        try {
            connection = this.openConnection(aParameters, url);
        }
        catch (IOException e) {
            throw new HttpConnectException("Cannot open connection to " + aUrl, (Throwable)e);
        }
        connection.setConnectTimeout(aParameters.getTimeouts().getConnectTimeoutMs());
        connection.setReadTimeout(aParameters.getTimeouts().getReadTimeoutMs());
        try {
            connection.setRequestMethod(aMethod.name());
        }
        catch (ProtocolException e) {
            throw new HttpConnectException("Cannot set request method " + aMethod + " for url " + aUrl, (Throwable)e);
        }
        return connection;
    }

    private HttpURLConnection openConnection(HttpRequestParameters aParameters, URL url) throws IOException {
        HttpProxyParameters proxyParameters = aParameters.getProxyParameters();
        if (proxyParameters == null || proxyParameters.getProxy() == null) {
            return (HttpURLConnection)url.openConnection();
        }
        return (HttpURLConnection)url.openConnection(proxyParameters.getProxy());
    }

    public static void readAllBytes(IHttpStreamResponseListener aListener, InputStream aInputStream) throws IOException {
        int count;
        byte[] buffer = new byte[4096];
        while ((count = aInputStream.read(buffer)) >= 0) {
            aListener.onBytes(buffer, 0, count);
        }
    }
}

