/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.http.client.impl;

import com.payneteasy.http.client.api.HttpHeader;
import com.payneteasy.http.client.api.HttpHeaders;
import com.payneteasy.http.client.api.HttpMethod;
import com.payneteasy.http.client.api.HttpProxyParameters;
import com.payneteasy.http.client.api.HttpRequest;
import com.payneteasy.http.client.api.HttpRequestParameters;
import com.payneteasy.http.client.api.HttpResponse;
import com.payneteasy.http.client.api.HttpTimeouts;
import com.payneteasy.http.client.api.IHttpClient;
import com.payneteasy.http.client.api.exceptions.HttpConnectException;
import com.payneteasy.http.client.api.exceptions.HttpReadException;
import com.payneteasy.http.client.api.exceptions.HttpWriteException;
import com.payneteasy.http.client.impl.HttpHeaderFinder;
import com.payneteasy.http.client.impl.LocalThreadProxyAuthenticator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import javax.net.ssl.SSLHandshakeException;

public class HttpClientImpl
implements IHttpClient {
    private static final Logger LOG = Logger.getLogger("http-client.HttpClientImpl");

    public static void registerGlobalProxyAuthenticator() {
        System.getProperties().put("jdk.http.auth.tunneling.disabledSchemes", "");
        System.getProperties().put("sun.net.client.defaultReadTimeout", "60000");
        System.getProperties().put("sun.net.client.defaultConnectTimeout", "20000");
        Authenticator.setDefault(new LocalThreadProxyAuthenticator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse send(HttpRequest aRequest, HttpRequestParameters aRequestParameters) throws HttpConnectException, HttpReadException, HttpWriteException {
        HttpProxyParameters proxyParameters = aRequestParameters.getProxyParameters();
        if (proxyParameters != null) {
            LocalThreadProxyAuthenticator.setParameters(proxyParameters);
        }
        try {
            String url = aRequest.getUrl();
            HttpURLConnection connection = this.createConnection(url, aRequest.getMethod(), aRequestParameters);
            this.sendHeaders(connection, aRequest.getHeaders());
            this.sendBody(url, connection, aRequest.getBody());
            HttpResponse httpResponse = this.parseResponse(url, connection, aRequestParameters.getTimeouts());
            return httpResponse;
        }
        finally {
            if (proxyParameters != null) {
                LocalThreadProxyAuthenticator.clear();
            }
        }
    }

    private HttpResponse parseResponse(String aUrl, HttpURLConnection aConnection, HttpTimeouts aTimeouts) throws HttpReadException, HttpConnectException {
        String reasonPhrase;
        int statusCode = this.waitForStatusCode(aUrl, aConnection, aTimeouts);
        try {
            reasonPhrase = aConnection.getResponseMessage();
        }
        catch (IOException e) {
            throw new HttpReadException("Cannot read reason phrase for url " + aUrl, (Throwable)e);
        }
        List<HttpHeader> headers = this.readHeaders(aConnection);
        byte[] body = this.readMessageBody(aUrl, statusCode, aConnection, headers);
        return new HttpResponse(statusCode, reasonPhrase, headers, body);
    }

    private int waitForStatusCode(String aUrl, HttpURLConnection aConnection, HttpTimeouts aTimeouts) throws HttpReadException, HttpConnectException {
        int statusCode;
        LOG.fine(String.format("Waiting for response code for %s with timeouts %s ...", aUrl, aTimeouts.toString()));
        try {
            statusCode = aConnection.getResponseCode();
        }
        catch (SSLHandshakeException e) {
            throw new HttpConnectException("Bad ssl certificate at " + aUrl, (Throwable)e);
        }
        catch (ConnectException e) {
            throw new HttpConnectException("Cannot connect to " + aUrl, (Throwable)e);
        }
        catch (IOException e) {
            throw new HttpReadException("Cannot wait for response code for url " + aUrl, (Throwable)e);
        }
        return statusCode;
    }

    private byte[] readMessageBody(String aUrl, int aStatusCode, HttpURLConnection aConnection, List<HttpHeader> aHeaders) throws HttpReadException {
        InputStream inputStream;
        try {
            inputStream = aStatusCode >= 400 ? aConnection.getErrorStream() : aConnection.getInputStream();
        }
        catch (IOException e) {
            throw new HttpReadException("Cannot create input stream for url " + aUrl, (Throwable)e);
        }
        if (inputStream == null) {
            return new byte[0];
        }
        int length = aConnection.getContentLength();
        if (length <= 0) {
            HttpHeaderFinder headerFinder = new HttpHeaderFinder(aHeaders);
            Optional<String> transferEncodingOption = headerFinder.get("Transfer-Encoding");
            if (!transferEncodingOption.isPresent()) {
                return new byte[0];
            }
            if (transferEncodingOption.get().contains("chunked")) {
                try {
                    return HttpClientImpl.readAllBytes(inputStream);
                }
                catch (IOException e) {
                    throw new HttpReadException("Cannot read chunked body from " + aUrl, (Throwable)e);
                }
            }
        }
        try {
            return HttpClientImpl.readFully(inputStream, length);
        }
        catch (IOException e) {
            throw new HttpReadException("Cannot read message body from " + aUrl, (Throwable)e);
        }
    }

    private List<HttpHeader> readHeaders(HttpURLConnection aConnection) {
        Map<String, List<String>> headerFields = aConnection.getHeaderFields();
        ArrayList<HttpHeader> headers = new ArrayList<HttpHeader>(headerFields.size());
        for (Map.Entry<String, List<String>> entry : headerFields.entrySet()) {
            String name;
            if (entry == null || (name = entry.getKey()) == null) continue;
            List<String> values = entry.getValue();
            if (values == null) {
                headers.add(new HttpHeader(name, ""));
                continue;
            }
            for (String value : values) {
                headers.add(new HttpHeader(name, value));
            }
        }
        return Collections.unmodifiableList(headers);
    }

    private void sendBody(String aUrl, HttpURLConnection aConnection, byte[] aRequestBody) throws HttpWriteException, HttpConnectException {
        if (aRequestBody == null || aRequestBody.length == 0) {
            return;
        }
        aConnection.setDoOutput(true);
        OutputStream outputStream = null;
        try {
            outputStream = aConnection.getOutputStream();
        }
        catch (ConnectException e) {
            throw new HttpConnectException("Cannot connect to " + aUrl, (Throwable)e);
        }
        catch (IOException e) {
            throw new HttpWriteException("Cannot create output stream for url " + aUrl, (Throwable)e);
        }
        try {
            outputStream.write(aRequestBody);
        }
        catch (IOException e) {
            throw new HttpWriteException("Cannot create write body to url " + aUrl, (Throwable)e);
        }
    }

    private void sendHeaders(HttpURLConnection aConnection, HttpHeaders aHeaders) {
        if (aHeaders == null) {
            return;
        }
        for (HttpHeader header : aHeaders.asList()) {
            aConnection.setRequestProperty(header.getName(), header.getValue());
        }
    }

    private HttpURLConnection createConnection(String aUrl, HttpMethod aMethod, HttpRequestParameters aParameters) throws HttpConnectException {
        HttpURLConnection connection;
        URL url;
        try {
            url = new URL(aUrl);
        }
        catch (MalformedURLException e) {
            throw new HttpConnectException("Cannot parse url: " + aUrl, (Throwable)e);
        }
        try {
            connection = this.openConnection(aParameters, url);
        }
        catch (IOException e) {
            throw new HttpConnectException("Cannot open connection to " + aUrl, (Throwable)e);
        }
        connection.setConnectTimeout(aParameters.getTimeouts().getConnectTimeoutMs());
        connection.setReadTimeout(aParameters.getTimeouts().getReadTimeoutMs());
        try {
            connection.setRequestMethod(aMethod.name());
        }
        catch (ProtocolException e) {
            throw new HttpConnectException("Cannot set request method " + aMethod + " for url " + aUrl, (Throwable)e);
        }
        return connection;
    }

    private HttpURLConnection openConnection(HttpRequestParameters aParameters, URL url) throws IOException {
        HttpProxyParameters proxyParameters = aParameters.getProxyParameters();
        if (proxyParameters == null || proxyParameters.getProxy() == null) {
            return (HttpURLConnection)url.openConnection();
        }
        return (HttpURLConnection)url.openConnection(proxyParameters.getProxy());
    }

    public static byte[] readFully(InputStream aInputStream, int length) throws IOException {
        int read;
        if (length <= 0) {
            return new byte[0];
        }
        byte[] buffer = new byte[length];
        int count = 0;
        do {
            if ((read = aInputStream.read(buffer, count, length - count)) >= 0) continue;
            throw new IOException("Read only " + count + " but wanted " + length + " (-1)");
        } while ((count += read) < length);
        return buffer;
    }

    public static byte[] readAllBytes(InputStream aInputStream) throws IOException {
        int count;
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        byte[] buffer = new byte[2048];
        while ((count = aInputStream.read(buffer)) >= 0) {
            byte[] bytes = new byte[count];
            System.arraycopy(buffer, 0, bytes, 0, count);
            list.add(bytes);
        }
        int size = 0;
        for (byte[] bytes : list) {
            size += bytes.length;
        }
        byte[] output = new byte[size];
        int position = 0;
        for (byte[] bytes : list) {
            System.arraycopy(bytes, 0, output, position, bytes.length);
            position += bytes.length;
        }
        return output;
    }
}

