/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.http.client.api;

import com.payneteasy.http.client.api.HttpHeader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;

public class HttpResponse {
    private final int statusCode;
    private final String reasonPhrase;
    private final List<HttpHeader> headers;
    private final byte[] body;

    public String toString() {
        return "HttpResponse(status=" + this.statusCode + " " + this.reasonPhrase + ", headers=" + this.headers + ", body=" + new String(this.body, StandardCharsets.UTF_8) + ")";
    }

    public HttpResponse(int statusCode, String reasonPhrase, List<HttpHeader> headers, byte[] body) {
        this.statusCode = statusCode;
        this.reasonPhrase = reasonPhrase;
        this.headers = headers;
        this.body = body;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getReasonPhrase() {
        return this.reasonPhrase;
    }

    public List<HttpHeader> getHeaders() {
        return this.headers;
    }

    public byte[] getBody() {
        return this.body;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpResponse)) {
            return false;
        }
        HttpResponse other = (HttpResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStatusCode() != other.getStatusCode()) {
            return false;
        }
        String this$reasonPhrase = this.getReasonPhrase();
        String other$reasonPhrase = other.getReasonPhrase();
        if (this$reasonPhrase == null ? other$reasonPhrase != null : !this$reasonPhrase.equals(other$reasonPhrase)) {
            return false;
        }
        List<HttpHeader> this$headers = this.getHeaders();
        List<HttpHeader> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        return Arrays.equals(this.getBody(), other.getBody());
    }

    protected boolean canEqual(Object other) {
        return other instanceof HttpResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getStatusCode();
        String $reasonPhrase = this.getReasonPhrase();
        result = result * 59 + ($reasonPhrase == null ? 43 : $reasonPhrase.hashCode());
        List<HttpHeader> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        result = result * 59 + Arrays.hashCode(this.getBody());
        return result;
    }
}

