/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.http.client.api;

import com.payneteasy.http.client.api.HttpHeaders;
import com.payneteasy.http.client.api.HttpMethod;
import java.util.Arrays;
import lombok.NonNull;

public class HttpRequest {
    @NonNull
    private final String url;
    private final HttpMethod method;
    private final HttpHeaders headers;
    private final byte[] body;

    private static HttpMethod $default$method() {
        return HttpMethod.GET;
    }

    HttpRequest(@NonNull String url, HttpMethod method, HttpHeaders headers, byte[] body) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        this.url = url;
        this.method = method;
        this.headers = headers;
        this.body = body;
    }

    public static HttpRequestBuilder builder() {
        return new HttpRequestBuilder();
    }

    @NonNull
    public String getUrl() {
        return this.url;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public byte[] getBody() {
        return this.body;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpRequest)) {
            return false;
        }
        HttpRequest other = (HttpRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        HttpMethod this$method = this.getMethod();
        HttpMethod other$method = other.getMethod();
        if (this$method == null ? other$method != null : !((Object)((Object)this$method)).equals((Object)other$method)) {
            return false;
        }
        HttpHeaders this$headers = this.getHeaders();
        HttpHeaders other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !this$headers.equals(other$headers)) {
            return false;
        }
        return Arrays.equals(this.getBody(), other.getBody());
    }

    protected boolean canEqual(Object other) {
        return other instanceof HttpRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        HttpMethod $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : ((Object)((Object)$method)).hashCode());
        HttpHeaders $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : $headers.hashCode());
        result = result * 59 + Arrays.hashCode(this.getBody());
        return result;
    }

    public String toString() {
        return "HttpRequest(url=" + this.getUrl() + ", method=" + (Object)((Object)this.getMethod()) + ", headers=" + this.getHeaders() + ", body=" + Arrays.toString(this.getBody()) + ")";
    }

    public static class HttpRequestBuilder {
        private String url;
        private boolean method$set;
        private HttpMethod method$value;
        private HttpHeaders headers;
        private byte[] body;

        HttpRequestBuilder() {
        }

        public HttpRequestBuilder url(@NonNull String url) {
            if (url == null) {
                throw new NullPointerException("url is marked non-null but is null");
            }
            this.url = url;
            return this;
        }

        public HttpRequestBuilder method(HttpMethod method) {
            this.method$value = method;
            this.method$set = true;
            return this;
        }

        public HttpRequestBuilder headers(HttpHeaders headers) {
            this.headers = headers;
            return this;
        }

        public HttpRequestBuilder body(byte[] body) {
            this.body = body;
            return this;
        }

        public HttpRequest build() {
            HttpMethod method$value = this.method$value;
            if (!this.method$set) {
                method$value = HttpRequest.$default$method();
            }
            return new HttpRequest(this.url, method$value, this.headers, this.body);
        }

        public String toString() {
            return "HttpRequest.HttpRequestBuilder(url=" + this.url + ", method$value=" + (Object)((Object)this.method$value) + ", headers=" + this.headers + ", body=" + Arrays.toString(this.body) + ")";
        }
    }
}

