/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.freemarker;

import com.payneteasy.jetty.util.SafeServletResponse;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FreemarkerInstance {
    private static final Logger LOG = LoggerFactory.getLogger(FreemarkerInstance.class);
    private final Template template;
    private final Map<String, Object> map = new HashMap<String, Object>();
    private String contentType = "text/html; charset=UTF-8";

    public FreemarkerInstance(Template template) {
        this.template = template;
    }

    public FreemarkerInstance add(String aKey, Object aValue) {
        this.map.put(aKey, aValue);
        return this;
    }

    public FreemarkerInstance contentType(String aContentType) {
        this.contentType = aContentType;
        return this;
    }

    public void write(SafeServletResponse response) {
        response.setContentType(this.contentType);
        response.setHeader("Cache-Control", "no-store, max-age=0");
        try {
            this.template.process(this.map, response.getWriter());
        }
        catch (IOException e) {
            LOG.error("Cannot write template {}", (Object)this.template, (Object)e);
            response.showErrorPage(500, "Cannot process template");
        }
        catch (TemplateException e) {
            LOG.error("Cannot process template {}", (Object)this.template, (Object)e);
            response.showErrorPage(500, "Cannot process template");
        }
    }

    public String createText() {
        try {
            StringWriter out = new StringWriter();
            this.template.process(this.map, (Writer)out);
            return out.toString();
        }
        catch (IOException e) {
            LOG.error("Cannot write template {}", (Object)this.template, (Object)e);
            throw new IllegalStateException("IO error while processing template", e);
        }
        catch (TemplateException e) {
            LOG.error("Cannot process template {}", (Object)this.template, (Object)e);
            throw new IllegalStateException("Template error while processing template", e);
        }
    }
}

