/*
 * Decompiled with CFR 0.152.
 */
package com.atomiccache.guava.impl;

import com.atomiccache.api.map.IAtomicCacheMap;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.time.Duration;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;

public class AtomicCacheMapGuavaImpl<K, V>
implements IAtomicCacheMap<K, V> {
    private final Cache<K, V> cache;

    public AtomicCacheMapGuavaImpl(int aMaxSize, Duration aExpireAfterWrite) {
        this.cache = CacheBuilder.newBuilder().maximumSize((long)aMaxSize).expireAfterWrite(aExpireAfterWrite).build();
    }

    public Optional<V> get(@NonNull K key) {
        return Optional.ofNullable(this.cache.getIfPresent(key));
    }

    public Optional<V> getAndPut(@NonNull K key, @NonNull V value, Duration aTtl) {
        Object previousValue = this.cache.getIfPresent(key);
        this.cache.put(key, value);
        return Optional.ofNullable(previousValue);
    }

    public Optional<V> getAndRemove(@NonNull K key) {
        Object previousValue = this.cache.getIfPresent(key);
        this.cache.invalidate(key);
        return Optional.ofNullable(previousValue);
    }

    public void put(@NonNull K key, @NonNull V value, Duration aTtl) {
        this.cache.put(key, value);
    }

    public void remove(@NonNull K key) {
        this.cache.invalidate(key);
    }
}

