/*
 * Decompiled with CFR 0.152.
 */
package com.atomiccache.guava.impl;

import com.atomiccache.api.cache.IAtomicCache;
import com.atomiccache.api.cache.IAtomicCacheFetch;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.time.Duration;
import java.util.concurrent.ExecutionException;
import org.checkerframework.checker.nullness.qual.NonNull;

public class AtomicCacheGuavaImpl<K, V>
implements IAtomicCache<K, V> {
    private final Cache<K, V> cache;

    public AtomicCacheGuavaImpl(int aMaxSize, Duration aExpireAfterWrite) {
        this.cache = CacheBuilder.newBuilder().maximumSize((long)aMaxSize).expireAfterWrite(aExpireAfterWrite).build();
    }

    public V getOrFetch(@NonNull K key, @NonNull IAtomicCacheFetch<K, V> aFetch) {
        try {
            return (V)this.cache.get(key, () -> aFetch.fetchValue(key));
        }
        catch (ExecutionException e) {
            throw new IllegalStateException("Cannot get value for key " + key, e);
        }
    }
}

