/*
 * Decompiled with CFR 0.152.
 */
package com.atomiccache.cassandra.impl.map;

import com.atomiccache.api.map.IAtomicCacheMap;
import com.atomiccache.api.serializer.IAtomicCacheSerializer;
import com.atomiccache.cassandra.impl.map.CassandraMapDaoImpl;
import java.time.Duration;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtomicCacheMapCassandraImpl<K, V>
implements IAtomicCacheMap<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(AtomicCacheMapCassandraImpl.class);
    private final IAtomicCacheSerializer<K, V> serializer;
    private final CassandraMapDaoImpl dao;

    public AtomicCacheMapCassandraImpl(IAtomicCacheSerializer<K, V> serializer, CassandraMapDaoImpl dao) {
        this.serializer = serializer;
        this.dao = dao;
    }

    public Optional<V> get(@NonNull K key) {
        return this.dao.select(this.serializer.serializeKey(key)).map(arg_0 -> this.serializer.deserializeValueFromText(arg_0));
    }

    public Optional<V> getAndPut(@NonNull K key, @NonNull V value, Duration aTtl) {
        Optional<V> previous = this.get(key);
        this.dao.put(this.serializer.serializeKey(key), this.serializer.serializeValue(value), aTtl);
        return previous;
    }

    public void put(@NonNull K key, @NonNull V value, Duration aTtl) {
        this.dao.put(this.serializer.serializeKey(key), this.serializer.serializeValue(value), aTtl);
    }

    public Optional<V> getAndRemove(@NonNull K key) {
        Optional<V> previous = this.get(key);
        this.dao.removeKey(this.serializer.serializeKey(key));
        return previous;
    }

    public void remove(@NonNull K key) {
        this.dao.removeKey(this.serializer.serializeKey(key));
    }
}

