/*
 * Decompiled with CFR 0.152.
 */
package com.atomiccache.cassandra.impl.lock.stmt;

import com.atomiccache.cassandra.impl.lock.stmt.LockSelectResult;
import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BoundStatementBuilder;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockSelectStatement {
    private static final Logger LOG = LoggerFactory.getLogger(LockSelectStatement.class);
    private final CqlSession session;
    private final PreparedStatement stmt;

    public LockSelectStatement(CqlSession session, String aTableName) {
        this.session = session;
        this.stmt = session.prepare("select key, owner from " + aTableName + " where key = ?");
    }

    public Optional<LockSelectResult> select(String key) {
        ResultSet rs = this.session.execute((Statement)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)this.stmt.boundStatementBuilder(new Object[0]).setString(0, key)).setSerialConsistencyLevel(ConsistencyLevel.LOCAL_SERIAL)).setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM)).build());
        Row row = (Row)rs.one();
        if (row == null) {
            return Optional.empty();
        }
        LockSelectResult selectResult = LockSelectResult.builder().key(row.getString("key")).owner(row.getString("owner")).build();
        LOG.debug("Select result: {}", (Object)selectResult);
        return Optional.of(selectResult);
    }
}

