/*
 * Decompiled with CFR 0.152.
 */
package com.atomiccache.cassandra.impl.lock;

import java.time.Duration;
import org.slf4j.Logger;

public class ThreadCondition {
    private final Duration sleep;
    private final Logger log;

    public ThreadCondition(Duration sleep, Logger aLogger) {
        this.sleep = sleep;
        this.log = aLogger;
    }

    public boolean awaitCanRun() {
        if (Thread.currentThread().isInterrupted()) {
            return false;
        }
        try {
            Thread.sleep(this.sleep.toMillis());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.log.debug("Interrupted sleep", (Throwable)e);
        }
        return !Thread.currentThread().isInterrupted();
    }
}

