/*
 * Decompiled with CFR 0.152.
 */
package com.atomiccache.cassandra.impl.lock;

import com.atomiccache.api.lock.IAtomicCacheLock;
import com.atomiccache.api.lock.IAtomicLock;
import com.atomiccache.api.serializer.IAtomicCacheKeySerializer;
import com.atomiccache.cassandra.impl.lock.AtomicCacheLockCassandraDaoImpl;
import com.atomiccache.cassandra.impl.lock.ThreadCondition;
import com.atomiccache.cassandra.impl.lock.stmt.AtomicLockCassandraImpl;
import com.atomiccache.cassandra.impl.lock.stmt.LockSelectResult;
import java.time.Duration;
import java.util.Optional;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class AtomicCacheLockCassandraImpl<K>
implements IAtomicCacheLock<K> {
    private static final Logger LOG = LoggerFactory.getLogger(AtomicCacheLockCassandraImpl.class);
    private final IAtomicCacheKeySerializer<K> keySerializer;
    private final AtomicCacheLockCassandraDaoImpl dao;
    private final Duration maxLockWait;
    private final Duration sleepBetweenChecks;

    public AtomicCacheLockCassandraImpl(IAtomicCacheKeySerializer<K> keySerializer, AtomicCacheLockCassandraDaoImpl dao, Duration maxLockWait, Duration sleepBetweenChecks) {
        this.keySerializer = keySerializer;
        this.dao = dao;
        this.maxLockWait = maxLockWait;
        this.sleepBetweenChecks = sleepBetweenChecks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAtomicLock lock(K aKey, Duration aDuration) {
        String keyText = this.keySerializer.serializeKey(aKey);
        MDC.put((String)"key", (String)keyText);
        try {
            IAtomicLock iAtomicLock = this.doLock(keyText, Thread.currentThread().getName() + "-" + UUID.randomUUID(), aDuration);
            return iAtomicLock;
        }
        finally {
            MDC.remove((String)"key");
        }
    }

    private IAtomicLock doLock(String aKey, String aOwner, Duration aDuration) {
        boolean isLockCreated = this.dao.insertLock(aKey, aOwner, aDuration);
        if (isLockCreated) {
            return new AtomicLockCassandraImpl(this.dao, aKey);
        }
        return this.waitUnlockInLoop(aKey, aOwner, aDuration);
    }

    private IAtomicLock waitUnlockInLoop(String aKey, String aOwner, Duration aDuration) {
        ThreadCondition condition = new ThreadCondition(this.sleepBetweenChecks, LOG);
        while (condition.awaitCanRun()) {
            Optional<LockSelectResult> selectResult = this.dao.selectLock(aKey);
            if (!selectResult.isPresent()) {
                LOG.warn("Lock not found, exiting: {}", selectResult);
                break;
            }
            LOG.debug("Waiting for unlock: {}, lock: {}", (Object)aKey, (Object)selectResult.get());
        }
        return this.doLock(aKey, aOwner, aDuration);
    }
}

