/*
 * Decompiled with CFR 0.152.
 */
package com.atomiccache.cassandra.impl.cache.dao.stmt;

import com.atomiccache.cassandra.impl.cache.model.AtomicCacheRecordState;
import com.atomiccache.cassandra.impl.cache.model.SelectResult;
import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BoundStatementBuilder;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import java.util.Optional;

public class SelectStatement {
    private final CqlSession session;
    private final PreparedStatement stmt;

    public SelectStatement(CqlSession session, String aTableName) {
        this.session = session;
        this.stmt = session.prepare("select * from " + aTableName + "\n where key = ?;");
    }

    public Optional<SelectResult> select(String key) {
        ResultSet rs = this.session.execute((Statement)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)this.stmt.boundStatementBuilder(new Object[0]).setString(0, key)).setSerialConsistencyLevel(ConsistencyLevel.LOCAL_SERIAL)).setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM)).build());
        Row row = (Row)rs.one();
        if (row == null) {
            return Optional.empty();
        }
        return Optional.of(SelectResult.builder().value(row.getString("value")).state(AtomicCacheRecordState.fromString(row.getString("state"))).build());
    }
}

