/*
 * Decompiled with CFR 0.152.
 */
package com.atomiccache.cassandra.impl.cache.dao;

import com.atomiccache.cassandra.impl.cache.dao.ICassandraDao;
import com.atomiccache.cassandra.impl.cache.dao.stmt.InsertStatement;
import com.atomiccache.cassandra.impl.cache.dao.stmt.SelectStatement;
import com.atomiccache.cassandra.impl.cache.dao.stmt.SetErrorStatement;
import com.atomiccache.cassandra.impl.cache.dao.stmt.SetValueStatement;
import com.atomiccache.cassandra.impl.cache.dao.stmt.UpdateStartFetchingStatement;
import com.atomiccache.cassandra.impl.cache.model.InsertResult;
import com.atomiccache.cassandra.impl.cache.model.SelectResult;
import com.atomiccache.cassandra.impl.cache.model.UpdateStartFetchingResult;
import com.datastax.oss.driver.api.core.CqlSession;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraDaoImpl
implements ICassandraDao {
    private static final Logger LOG = LoggerFactory.getLogger(CassandraDaoImpl.class);
    private final InsertStatement insertStatement;
    private final SelectStatement selectStatement;
    private final SetErrorStatement setErrorStatement;
    private final SetValueStatement setValueStatement;
    private final UpdateStartFetchingStatement updateStartFetchingStatement;

    public CassandraDaoImpl(CqlSession session, String aTableName, Duration rowTtl) {
        this.insertStatement = new InsertStatement(session, aTableName, rowTtl);
        this.selectStatement = new SelectStatement(session, aTableName);
        this.setErrorStatement = new SetErrorStatement(session, aTableName);
        this.setValueStatement = new SetValueStatement(session, aTableName);
        this.updateStartFetchingStatement = new UpdateStartFetchingStatement(session, aTableName);
    }

    @Override
    public InsertResult insert(String keyText, Instant now, UUID aFetchId) {
        LOG.atDebug().addKeyValue("started_fetching_at", (Object)now).addKeyValue("fetch_id", (Object)aFetchId).log("insert()");
        InsertResult result = this.insertStatement.insert(keyText, now, aFetchId);
        LOG.atDebug().addKeyValue("was_applied", (Object)result.isWasApplied()).addKeyValue("state", (Object)result.getState()).addKeyValue("started_fetching_at", (Object)result.getStartFetchingAt()).addKeyValue("value", (Object)result.getValue()).addKeyValue("fetch_id", (Object)result.getFetchId()).log("insert() result");
        return result;
    }

    @Override
    public Optional<SelectResult> select(String keyText) {
        Optional<SelectResult> result = this.selectStatement.select(keyText);
        if (result.isPresent()) {
            LOG.atDebug().addKeyValue("state", (Object)result.get().getState()).addKeyValue("value", (Object)result.get().getValue()).log("select()");
        } else {
            LOG.atDebug().log("select() returned no result");
        }
        return result;
    }

    @Override
    public void setError(String keyText, String aErrorMessage) {
        LOG.atDebug().addKeyValue("error_message", (Object)aErrorMessage).log("setError()");
        this.setErrorStatement.setError(keyText, aErrorMessage);
    }

    @Override
    public void setValue(String keyText, @NonNull String aValue) {
        LOG.atDebug().addKeyValue("value", (Object)aValue).log("setValue()");
        this.setValueStatement.setValue(keyText, aValue);
    }

    @Override
    public UpdateStartFetchingResult updateStartedFetchingAt(String keyText, Instant now, UUID aPreviousFetchId, UUID aNewFetchId) {
        LOG.atDebug().addKeyValue("started_fetching_at", (Object)now).addKeyValue("previous_fetch_id", (Object)aPreviousFetchId).addKeyValue("new_fetch_id", (Object)aNewFetchId).log("updateStartedFetchingAt()");
        UpdateStartFetchingResult result = this.updateStartFetchingStatement.updateStartedFetchingAt(keyText, now, aPreviousFetchId, aNewFetchId);
        LOG.atDebug().addKeyValue("was_applied", (Object)result.isApplied()).addKeyValue("fetch_id", (Object)result.getFetchId()).log("updateStartedFetchingAt() result");
        return result;
    }
}

