/*
 * Decompiled with CFR 0.152.
 */
package com.atomiccache.api.serializer;

import com.atomiccache.api.serializer.IAtomicCacheKeySerializer;
import com.atomiccache.api.serializer.IAtomicCacheSerializer;
import com.atomiccache.api.serializer.IAtomicCacheValueDeserializer;
import com.atomiccache.api.serializer.IAtomicCacheValueSerializer;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public class AtomicCacheSerializerContainer<K, V>
implements IAtomicCacheSerializer<K, V> {
    private final IAtomicCacheKeySerializer<K> keySerializer;
    private final IAtomicCacheValueDeserializer<V> valueDeserializer;
    private final IAtomicCacheValueSerializer<V> valueSerializer;

    public AtomicCacheSerializerContainer(IAtomicCacheKeySerializer<K> keySerializer, IAtomicCacheValueDeserializer<V> valueDeserializer, IAtomicCacheValueSerializer<V> valueSerializer) {
        this.keySerializer = Objects.requireNonNull(keySerializer, "No KeySerializer provided");
        this.valueDeserializer = Objects.requireNonNull(valueDeserializer, "No ValueDeserializer provided");
        this.valueSerializer = Objects.requireNonNull(valueSerializer, " No ValueSerializer provided");
    }

    @Override
    public @NonNull String serializeKey(@NonNull K key) {
        return this.keySerializer.serializeKey(key);
    }

    @Override
    public @NonNull V deserializeValueFromText(@NonNull String aText) {
        return this.valueDeserializer.deserializeValueFromText(aText);
    }

    @Override
    public @NonNull String serializeValue(@NonNull V aValue) {
        return this.valueSerializer.serializeValue(aValue);
    }
}

