/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.atomiccache.concurrent;

import com.payneteasy.atomiccache.api.IAtomicCache;
import com.payneteasy.atomiccache.api.IAtomicCacheFetch;
import java.util.concurrent.ConcurrentHashMap;
import org.checkerframework.checker.nullness.qual.NonNull;

public class AtomicCacheConcurrentImpl<K, V>
implements IAtomicCache<K, V> {
    private final ConcurrentHashMap<K, V> map = new ConcurrentHashMap();

    @Override
    public V getOrFetch(@NonNull K aKey, @NonNull IAtomicCacheFetch<K, V> aFetch) {
        return (V)this.map.computeIfAbsent(aKey, key -> {
            try {
                return aFetch.fetchValue(aKey);
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot fetch value for key " + key, e);
            }
        });
    }

    @Override
    public void close() {
    }
}

