/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.apigen.swagger;

import com.payneteasy.apigen.core.util.Methods;
import com.payneteasy.apigen.swagger.SwaggerBuilderStrategy;
import com.payneteasy.apigen.swagger.impl.SwaggerMethodComponents;
import com.payneteasy.apigen.swagger.impl.SwaggerMethodPathItem;
import com.payneteasy.apigen.swagger.impl.sorted.SortedPaths;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.tags.Tag;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwaggerBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(SwaggerBuilder.class);
    private final OpenAPI api;
    private final List<Class<?>> interfaces;
    private final SwaggerBuilderStrategy.IPathExtractor methodPathExtractor;
    private final SwaggerMethodPathItem swaggerMethodPathItem;
    private final List<Class<?>> errorClasses;
    private final SwaggerBuilderStrategy.IMethodAcceptor methodAcceptor;
    private final SwaggerBuilderStrategy.IServiceDescriptionExtractor serviceDescription;
    private final SwaggerBuilderStrategy.IServiceAddListener serviceAddListener;

    public SwaggerBuilder(@Nonnull OpenAPI aOpenApi, @Nonnull SwaggerBuilderStrategy.IMethodAcceptor aMethodAcceptor, @Nonnull List<Class<?>> aInterfaces, @Nonnull SwaggerBuilderStrategy.IPathExtractor aMethodPathExtractor, @Nonnull SwaggerBuilderStrategy.ISecurityItemExtractor aSecurityItemExtractor, @Nonnull SwaggerBuilderStrategy.IServiceDescriptionExtractor aServiceDescriptionExtractor, @Nonnull SwaggerBuilderStrategy.IOperationDescriptionExtractor aOperationDescriptionExtractor, @Nonnull SwaggerBuilderStrategy.IPathParameters aAdditionalParameters, @Nonnull List<Class<?>> aErrorClasses, @Nonnull SwaggerBuilderStrategy.IErrorResponsesExtractor aErrorResponsesExtractor, @Nonnull SwaggerBuilderStrategy.IServiceAddListener aServiceAddListener, @Nonnull SwaggerBuilderStrategy.IRequestExamples aRequestExamples, @Nonnull SwaggerBuilderStrategy.IResponseExamples aResponseExamples) {
        this.interfaces = SwaggerBuilder.createSortedArray(aInterfaces);
        this.api = aOpenApi;
        this.methodPathExtractor = aMethodPathExtractor;
        this.errorClasses = aErrorClasses;
        this.methodAcceptor = aMethodAcceptor;
        this.serviceDescription = aServiceDescriptionExtractor;
        this.serviceAddListener = aServiceAddListener;
        this.swaggerMethodPathItem = new SwaggerMethodPathItem(aServiceDescriptionExtractor, aOperationDescriptionExtractor, aMethodPathExtractor, aSecurityItemExtractor, aAdditionalParameters, aErrorResponsesExtractor, aRequestExamples, aResponseExamples);
    }

    private static List<Class<?>> createSortedArray(List<Class<?>> aInterfaces) {
        ArrayList classes = new ArrayList(aInterfaces);
        classes.sort(Comparator.comparing(Class::getSimpleName));
        return classes;
    }

    public OpenAPI buildOpenApiModel() {
        this.api.tags(this.getTags(this.interfaces)).paths(this.createPaths(this.interfaces)).setComponents(new SwaggerMethodComponents(this.errorClasses, this.methodAcceptor).createComponents(this.interfaces));
        return this.api;
    }

    private Paths createPaths(List<Class<?>> aInterfaces) {
        SortedPaths paths = new SortedPaths();
        for (Class<?> clazz : aInterfaces) {
            this.serviceAddListener.onServiceAdd(paths, clazz);
            for (Method method : Methods.getAllMethods(clazz)) {
                if (!this.methodAcceptor.isMethodAccepted(clazz, method)) continue;
                try {
                    paths.addPathItem(this.methodPathExtractor.getMethodPath(clazz, method), this.swaggerMethodPathItem.createPathItem(clazz, method));
                }
                catch (Exception e) {
                    LOG.error("Cannot create path items for method {}.{}()", (Object)clazz.getSimpleName(), (Object)method.getName());
                }
            }
        }
        return paths;
    }

    private PathItem createOverviewPathItem(Class<?> aClass) {
        Operation operation = new Operation();
        operation.addTagsItem(aClass.getSimpleName());
        operation.summary("Overview");
        this.serviceDescription.getServiceDescription(aClass).ifPresent(arg_0 -> ((Operation)operation).description(arg_0));
        PathItem item = new PathItem();
        item.operation(PathItem.HttpMethod.HEAD, operation);
        return item;
    }

    private List<Tag> getTags(List<Class<?>> aInterfaces) {
        return aInterfaces.stream().map(trait -> new Tag().name(trait.getSimpleName()).description(this.serviceDescription.getServiceDescription((Class<?>)trait).orElse(trait.getSimpleName()))).collect(Collectors.toList());
    }
}

