/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.apigen.swagger.impl;

import com.payneteasy.apigen.core.util.Fields;
import com.payneteasy.apigen.core.util.Methods;
import com.payneteasy.apigen.swagger.SwaggerBuilderStrategy;
import com.payneteasy.apigen.swagger.impl.SwaggerSchemas;
import io.swagger.v3.core.converter.ModelConverters;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.media.Schema;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwaggerMethodComponents {
    private static final Logger LOG = LoggerFactory.getLogger(SwaggerMethodComponents.class);
    private final ModelConverters converters = ModelConverters.getInstance();
    private final Set<Class<?>> added = new HashSet();
    private final List<Class<?>> errorClasses;
    private final Components components = new Components();
    private final SwaggerBuilderStrategy.IMethodAcceptor methodAcceptor;

    public SwaggerMethodComponents(@Nonnull List<Class<?>> errorClasses, SwaggerBuilderStrategy.IMethodAcceptor aMethodAcceptor) {
        this.errorClasses = errorClasses;
        this.methodAcceptor = aMethodAcceptor;
    }

    public Components createComponents(List<Class<?>> aInterfaces) {
        for (Class<?> clazz : aInterfaces) {
            for (Method method : Methods.getAllMethods(clazz)) {
                if (!this.methodAcceptor.isMethodAccepted(clazz, method)) continue;
                try {
                    this.addTypes(method.getReturnType(), method.getGenericReturnType());
                    for (int i = 0; i < method.getParameterTypes().length; ++i) {
                        this.addTypes(method.getParameterTypes()[i], method.getGenericParameterTypes()[i]);
                    }
                }
                catch (Exception e) {
                    LOG.error("Cannot processes {}.{}()", new Object[]{clazz.getSimpleName(), method.getName(), e});
                }
            }
        }
        for (Class<?> errorClass : this.errorClasses) {
            this.addTypes(errorClass, null);
        }
        return this.components;
    }

    private void addTypes(Class<?> aClass, Type aType) {
        if (SwaggerSchemas.isCollection(aClass)) {
            Class<?> collectionGenericType = SwaggerSchemas.getCollectionGenericType(aType);
            this.addTypes(collectionGenericType, null);
            return;
        }
        if (this.added.contains(aClass)) {
            return;
        }
        this.added.add(aClass);
        Map map = this.converters.read(aClass);
        for (Map.Entry entry : map.entrySet()) {
            this.components.addSchemas((String)entry.getKey(), (Schema)entry.getValue());
        }
        for (Field field : Fields.getAllFields(aClass)) {
            if (SwaggerSchemas.isOurType(field)) {
                this.addTypes(field.getType(), field.getGenericType());
                continue;
            }
            if (!SwaggerSchemas.isCollection(field.getType())) continue;
            this.addTypes(SwaggerSchemas.getCollectionGenericType(field), field.getGenericType());
        }
    }
}

