/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.apigen.swagger;

import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;

public interface SwaggerBuilderStrategy {

    public static class ErrorResponseInfo {
        private final int httpStatusCode;
        private final String description;
        private final Class<?> responseClass;

        public String getName() {
            return String.valueOf(this.httpStatusCode);
        }

        ErrorResponseInfo(int httpStatusCode, String description, Class<?> responseClass) {
            this.httpStatusCode = httpStatusCode;
            this.description = description;
            this.responseClass = responseClass;
        }

        public static ErrorResponseInfoBuilder builder() {
            return new ErrorResponseInfoBuilder();
        }

        public int getHttpStatusCode() {
            return this.httpStatusCode;
        }

        public String getDescription() {
            return this.description;
        }

        public Class<?> getResponseClass() {
            return this.responseClass;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ErrorResponseInfo)) {
                return false;
            }
            ErrorResponseInfo other = (ErrorResponseInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getHttpStatusCode() != other.getHttpStatusCode()) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            Class<?> this$responseClass = this.getResponseClass();
            Class<?> other$responseClass = other.getResponseClass();
            return !(this$responseClass == null ? other$responseClass != null : !this$responseClass.equals(other$responseClass));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ErrorResponseInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getHttpStatusCode();
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            Class<?> $responseClass = this.getResponseClass();
            result = result * 59 + ($responseClass == null ? 43 : $responseClass.hashCode());
            return result;
        }

        public String toString() {
            return "SwaggerBuilderStrategy.ErrorResponseInfo(httpStatusCode=" + this.getHttpStatusCode() + ", description=" + this.getDescription() + ", responseClass=" + this.getResponseClass() + ")";
        }

        public static class ErrorResponseInfoBuilder {
            private int httpStatusCode;
            private String description;
            private Class<?> responseClass;

            ErrorResponseInfoBuilder() {
            }

            public ErrorResponseInfoBuilder httpStatusCode(int httpStatusCode) {
                this.httpStatusCode = httpStatusCode;
                return this;
            }

            public ErrorResponseInfoBuilder description(String description) {
                this.description = description;
                return this;
            }

            public ErrorResponseInfoBuilder responseClass(Class<?> responseClass) {
                this.responseClass = responseClass;
                return this;
            }

            public ErrorResponseInfo build() {
                return new ErrorResponseInfo(this.httpStatusCode, this.description, this.responseClass);
            }

            public String toString() {
                return "SwaggerBuilderStrategy.ErrorResponseInfo.ErrorResponseInfoBuilder(httpStatusCode=" + this.httpStatusCode + ", description=" + this.description + ", responseClass=" + this.responseClass + ")";
            }
        }
    }

    public static interface IServiceAddListener {
        public void onServiceAdd(Paths var1, Class<?> var2);
    }

    public static interface ISecurityItemExtractor {
        public Optional<SecurityRequirement> getSecurityItem(Class<?> var1, Method var2);
    }

    public static interface IPathExtractor {
        @Nonnull
        public String getMethodPath(Class<?> var1, Method var2);
    }

    public static interface IResponseExamples {
        @Nonnull
        public List<String> getResponseExamples(String var1, Class<?> var2, Method var3);
    }

    public static interface IServiceDescriptionExtractor {
        public Optional<String> getServiceDescription(Class<?> var1);
    }

    public static interface IOperationDescriptionExtractor {
        public Optional<String> getOperationDescription(String var1, Class<?> var2, Method var3);
    }

    public static interface IErrorResponsesExtractor {
        public List<ErrorResponseInfo> getErrorResponse(String var1, Class<?> var2, Method var3);
    }

    public static interface IPathParameters {
        public List<Parameter> getPathParameters(String var1, Class<?> var2, Method var3);
    }

    public static interface IMethodAcceptor {
        public boolean isMethodAccepted(Class<?> var1, Method var2);
    }
}

