/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.apigen.swagger.impl;

import io.swagger.v3.core.util.PrimitiveType;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;

public class SwaggerSchemas {
    public static Schema<?> createSchema(Class<?> aClass, String aLocation) {
        return SwaggerSchemas.createSchema(aClass, null, aLocation);
    }

    public static Schema<?> createSchema(Class<?> aClass, Type aType, String aLocation) {
        PrimitiveType primitiveType = PrimitiveType.fromType(aClass);
        if (primitiveType != null) {
            return primitiveType.createProperty();
        }
        if (SwaggerSchemas.isOurType(aClass)) {
            return new ObjectSchema().$ref("#/components/schemas/" + aClass.getSimpleName());
        }
        if (SwaggerSchemas.isCollection(aClass)) {
            return new ArraySchema().items(SwaggerSchemas.createSchema(SwaggerSchemas.getCollectionGenericType(aType), aLocation + " is collection"));
        }
        throw new IllegalStateException("No any schema type for " + aClass + " : " + aLocation);
    }

    static boolean isOurType(Field field) {
        return SwaggerSchemas.isOurType(field.getType());
    }

    static boolean isOurType(Class<?> type) {
        if (type.isPrimitive()) {
            return false;
        }
        return !type.getName().startsWith("java");
    }

    static boolean isCollection(Class<?> aClass) {
        return Collection.class.isAssignableFrom(aClass);
    }

    static Class<?> getCollectionGenericType(Field aField) {
        ParameterizedType genericType = (ParameterizedType)aField.getGenericType();
        return (Class)genericType.getActualTypeArguments()[0];
    }

    static Class<?> getCollectionGenericType(Type aType) {
        ParameterizedType genericType = (ParameterizedType)aType;
        return (Class)genericType.getActualTypeArguments()[0];
    }
}

