/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.apigen.swagger.impl;

import com.payneteasy.apigen.core.util.Fields;
import com.payneteasy.apigen.core.util.Methods;
import com.payneteasy.apigen.swagger.SwaggerBuilderStrategy;
import com.payneteasy.apigen.swagger.impl.SwaggerSchemas;
import io.swagger.v3.core.converter.ModelConverters;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.media.Schema;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwaggerMethodComponents {
    private static final Logger LOG = LoggerFactory.getLogger(SwaggerMethodComponents.class);
    private final ModelConverters converters = ModelConverters.getInstance();
    private final Set<Class<?>> added = new HashSet();
    private final List<Class<?>> errorClasses;
    private final Components components = new Components();
    private final SwaggerBuilderStrategy.IMethodAcceptor methodAcceptor;

    public SwaggerMethodComponents(@Nonnull List<Class<?>> errorClasses, SwaggerBuilderStrategy.IMethodAcceptor aMethodAcceptor) {
        this.errorClasses = errorClasses;
        this.methodAcceptor = aMethodAcceptor;
    }

    public Components createComponents(List<Class<?>> aInterfaces) {
        for (Class<?> clazz : aInterfaces) {
            for (Method method : Methods.getAllMethods(clazz)) {
                if (!this.methodAcceptor.isMethodAccepted(clazz, method)) continue;
                try {
                    this.addTypes(method.getReturnType());
                    for (Class<?> parameterType : method.getParameterTypes()) {
                        this.addTypes(parameterType);
                    }
                }
                catch (Exception e) {
                    LOG.error("Cannot processes {}.{}()", (Object)clazz.getSimpleName(), (Object)method.getName());
                }
            }
        }
        for (Class<?> errorClass : this.errorClasses) {
            this.addTypes(errorClass);
        }
        return this.components;
    }

    private void addTypes(Class<?> aType) {
        if (this.added.contains(aType)) {
            return;
        }
        this.added.add(aType);
        Map map = this.converters.read(aType);
        for (Map.Entry entry : map.entrySet()) {
            this.components.addSchemas((String)entry.getKey(), (Schema)entry.getValue());
        }
        for (Field field : Fields.getAllFields(aType)) {
            if (SwaggerSchemas.isOurType(field)) {
                this.addTypes(field.getType());
                continue;
            }
            if (!SwaggerSchemas.isCollection(field.getType())) continue;
            this.addTypes(SwaggerSchemas.getCollectionGenericType(field));
        }
    }
}

