/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.apigen.swagger;

import com.payneteasy.apigen.core.util.Methods;
import com.payneteasy.apigen.swagger.SwaggerBuilderStrategy;
import com.payneteasy.apigen.swagger.impl.SwaggerMethodComponents;
import com.payneteasy.apigen.swagger.impl.SwaggerMethodPathItem;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.tags.Tag;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class SwaggerBuilder {
    private final OpenAPI api;
    private final List<Class<?>> interfaces;
    private final SwaggerBuilderStrategy.IPathExtractor methodPathExtractor;
    private final SwaggerMethodPathItem swaggerMethodPathItem;
    private final List<Class<?>> errorClasses;
    private final SwaggerBuilderStrategy.IMethodAcceptor methodAcceptor;

    public SwaggerBuilder(@Nonnull OpenAPI aOpenApi, @Nonnull SwaggerBuilderStrategy.IMethodAcceptor aMethodAcceptor, @Nonnull List<Class<?>> aInterfaces, @Nonnull SwaggerBuilderStrategy.IPathExtractor aMethodPathExtractor, @Nonnull SwaggerBuilderStrategy.ISecurityItemExtractor aSecurityItemExtractor, @Nonnull SwaggerBuilderStrategy.IOperationDescriptionExtractor aOperationDescriptionExtractor, @Nonnull SwaggerBuilderStrategy.IAdditionalParameters aAdditionalParameters, @Nonnull List<Class<?>> aErrorClasses, @Nonnull SwaggerBuilderStrategy.IErrorResponsesExtractor aErrorResponsesExtractor) {
        this.interfaces = aInterfaces;
        this.api = aOpenApi;
        this.methodPathExtractor = aMethodPathExtractor;
        this.errorClasses = aErrorClasses;
        this.methodAcceptor = aMethodAcceptor;
        this.swaggerMethodPathItem = new SwaggerMethodPathItem(aOperationDescriptionExtractor, aMethodPathExtractor, aSecurityItemExtractor, aAdditionalParameters, aErrorResponsesExtractor);
    }

    public OpenAPI buildOpenApiModel() {
        this.api.tags(this.getTags(this.interfaces)).paths(this.createPaths(this.interfaces)).setComponents(new SwaggerMethodComponents(this.errorClasses, this.methodAcceptor).createComponents(this.interfaces));
        return this.api;
    }

    private Paths createPaths(List<Class<?>> aInterfaces) {
        SortedPaths paths = new SortedPaths();
        for (Class<?> clazz : aInterfaces) {
            for (Method method : Methods.getAllMethods(clazz)) {
                if (!this.methodAcceptor.isMethodAccepted(clazz, method)) continue;
                paths.addPathItem(this.methodPathExtractor.getMethodPath(clazz, method), this.swaggerMethodPathItem.createPathItem(clazz, method));
            }
        }
        return paths;
    }

    private List<Tag> getTags(List<Class<?>> aInterfaces) {
        return aInterfaces.stream().map(trait -> new Tag().name(trait.getSimpleName()).description(trait.getSimpleName())).collect(Collectors.toList());
    }

    private static class SortedMapEntry
    implements Map.Entry<String, PathItem>,
    Comparable<SortedMapEntry> {
        private final Map.Entry<String, PathItem> delegate;

        public SortedMapEntry(Map.Entry<String, PathItem> delegate) {
            this.delegate = delegate;
        }

        @Override
        public int compareTo(@Nonnull SortedMapEntry another) {
            return this.delegate.getKey().compareTo(another.getKey());
        }

        @Override
        public String getKey() {
            return this.delegate.getKey();
        }

        @Override
        public PathItem getValue() {
            return this.delegate.getValue();
        }

        @Override
        public PathItem setValue(PathItem value) {
            return this.delegate.setValue(value);
        }
    }

    private static class SortedPaths
    extends Paths {
        private SortedPaths() {
        }

        public Set<Map.Entry<String, PathItem>> entrySet() {
            TreeSet<Map.Entry<String, PathItem>> set = new TreeSet<Map.Entry<String, PathItem>>();
            for (Map.Entry entry : super.entrySet()) {
                set.add(new SortedMapEntry(entry));
            }
            return set;
        }
    }
}

