/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.apigen.swagger.impl;

import com.payneteasy.apigen.swagger.SwaggerBuilderStrategy;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;

public class SwaggerMethodPathItem {
    private final SwaggerBuilderStrategy.IPathExtractor pathExtractor;
    private final SwaggerBuilderStrategy.ISecurityItemExtractor securityItemExtractor;
    private final SwaggerBuilderStrategy.IOperationDescriptionExtractor operationDescriptionExtractor;
    private final SwaggerBuilderStrategy.IAdditionalParameters additionalParameters;
    private final SwaggerBuilderStrategy.IErrorResponsesExtractor errorResponsesExtractor;

    public SwaggerMethodPathItem(SwaggerBuilderStrategy.IOperationDescriptionExtractor aOperationDescriptionExtractor, SwaggerBuilderStrategy.IPathExtractor pathExtractor, SwaggerBuilderStrategy.ISecurityItemExtractor securityItemExtractor, SwaggerBuilderStrategy.IAdditionalParameters aAdditionalParameters, SwaggerBuilderStrategy.IErrorResponsesExtractor aErrorResponsesExtractor) {
        this.operationDescriptionExtractor = aOperationDescriptionExtractor;
        this.pathExtractor = pathExtractor;
        this.securityItemExtractor = securityItemExtractor;
        this.additionalParameters = aAdditionalParameters;
        this.errorResponsesExtractor = aErrorResponsesExtractor;
    }

    public PathItem createPathItem(Class<?> clazz, Method aMethod) {
        String path = this.pathExtractor.getMethodPath(clazz, aMethod);
        PathItem item = new PathItem();
        Operation operation = this.getOperation(path, clazz, aMethod);
        item.operation(PathItem.HttpMethod.POST, operation);
        this.securityItemExtractor.getSecurityItem(clazz, aMethod).ifPresent(arg_0 -> ((Operation)operation).addSecurityItem(arg_0));
        this.operationDescriptionExtractor.getOperationDescription(path, clazz, aMethod).ifPresent(arg_0 -> ((Operation)operation).description(arg_0));
        this.additionalParameters.getAdditionalParameters(path, clazz, aMethod).forEach(arg_0 -> ((PathItem)item).addParametersItem(arg_0));
        return item;
    }

    @Nonnull
    private Operation getOperation(String aPath, Class<?> clazz, Method aMethod) {
        Operation operation = new Operation();
        operation.addTagsItem(clazz.getSimpleName());
        if (!"VoidRequest".equals(this.getParameterName(aMethod))) {
            operation.requestBody(this.createRequestBody(aMethod));
        }
        operation.responses(this.createResponse(aPath, clazz, aMethod));
        return operation;
    }

    private ApiResponses createResponse(String aPath, Class<?> aClass, Method aMethod) {
        ApiResponses responses = new ApiResponses().addApiResponse("200", new ApiResponse().description("Success response").content(new Content().addMediaType("application/json", new MediaType().schema(new Schema().$ref("#/components/schemas/" + aMethod.getReturnType().getSimpleName())))));
        this.errorResponsesExtractor.getErrorResponse(aPath, aClass, aMethod).forEach(error -> responses.addApiResponse(error.getName(), new ApiResponse().description(error.getDescription()).content(this.errorJson(error.getResponseClass()))));
        return responses;
    }

    private Content errorJson(Class<?> aClass) {
        return new Content().addMediaType("application/json; charset=utf-8", new MediaType().schema(new Schema().$ref("#/components/schemas/" + aClass.getSimpleName())));
    }

    private RequestBody createRequestBody(Method aMethod) {
        return new RequestBody().content(new Content().addMediaType("application/json", new MediaType().schema(new Schema().$ref("#/components/schemas/" + this.getParameterName(aMethod)))));
    }

    @Nonnull
    private String getParameterName(Method aMethod) {
        return aMethod.getParameterTypes()[0].getSimpleName();
    }
}

