/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.apigen.swagger.impl;

import com.payneteasy.apigen.core.util.Fields;
import com.payneteasy.apigen.core.util.Methods;
import io.swagger.v3.core.converter.ModelConverters;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.media.Schema;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class SwaggerMethodComponents {
    private final ModelConverters converters = ModelConverters.getInstance();
    private final Set<Class<?>> added = new HashSet();
    private final List<Class<?>> errorClasses;

    public SwaggerMethodComponents(@Nonnull List<Class<?>> errorClasses) {
        this.errorClasses = errorClasses;
    }

    public Components createComponents(List<Class<?>> aInterfaces) {
        Components components = new Components();
        for (Class<?> clazz : aInterfaces) {
            for (Method method : Methods.getAllMethods(clazz)) {
                this.addTypes(components, method.getReturnType());
                this.addTypes(components, method.getParameterTypes()[0]);
            }
        }
        for (Class<?> errorClass : this.errorClasses) {
            this.addTypes(components, errorClass);
        }
        return components;
    }

    private void addTypes(Components aComponents, Class<?> aType) {
        if (this.added.contains(aType)) {
            return;
        }
        this.added.add(aType);
        Map map = this.converters.read(aType);
        for (Map.Entry entry : map.entrySet()) {
            aComponents.addSchemas((String)entry.getKey(), (Schema)entry.getValue());
        }
        for (Field field : Fields.getAllFields(aType)) {
            if (!this.isOurType(field)) continue;
            this.addTypes(aComponents, field.getType());
        }
    }

    private boolean isOurType(Field field) {
        Class<?> type = field.getType();
        if (type.isPrimitive()) {
            return false;
        }
        return !type.getName().startsWith("java");
    }
}

