/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.apigen.swagger.impl;

import com.payneteasy.apigen.swagger.SwaggerBuilderStrategy;
import com.payneteasy.apigen.swagger.impl.MethodParameter;
import com.payneteasy.apigen.swagger.impl.MethodParameters;
import com.payneteasy.apigen.swagger.impl.SwaggerSchemas;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class SwaggerMethodPathItem {
    private final SwaggerBuilderStrategy.IPathExtractor pathExtractor;
    private final SwaggerBuilderStrategy.ISecurityItemExtractor securityItemExtractor;
    private final SwaggerBuilderStrategy.IOperationDescriptionExtractor operationDescriptionExtractor;
    private final SwaggerBuilderStrategy.IPathParameters additionalParameters;
    private final SwaggerBuilderStrategy.IErrorResponsesExtractor errorResponsesExtractor;
    private final SwaggerBuilderStrategy.IRequestExamples requestExample;
    private final SwaggerBuilderStrategy.IResponseExamples responseExamples;
    private final SwaggerBuilderStrategy.IServiceTagExtractor serviceTagExtractor;
    private final SwaggerBuilderStrategy.IOperationSummary operationSummary;

    public SwaggerMethodPathItem(SwaggerBuilderStrategy.IOperationDescriptionExtractor aOperationDescriptionExtractor, SwaggerBuilderStrategy.IPathExtractor pathExtractor, SwaggerBuilderStrategy.ISecurityItemExtractor securityItemExtractor, SwaggerBuilderStrategy.IPathParameters aAdditionalParameters, SwaggerBuilderStrategy.IErrorResponsesExtractor aErrorResponsesExtractor, SwaggerBuilderStrategy.IRequestExamples aRequestExamples, SwaggerBuilderStrategy.IResponseExamples aResponseExamples, SwaggerBuilderStrategy.IServiceTagExtractor aServiceTagExtractor, SwaggerBuilderStrategy.IOperationSummary aOperationSummary) {
        this.operationDescriptionExtractor = aOperationDescriptionExtractor;
        this.pathExtractor = pathExtractor;
        this.securityItemExtractor = securityItemExtractor;
        this.additionalParameters = aAdditionalParameters;
        this.errorResponsesExtractor = aErrorResponsesExtractor;
        this.requestExample = aRequestExamples;
        this.responseExamples = aResponseExamples;
        this.serviceTagExtractor = aServiceTagExtractor;
        this.operationSummary = aOperationSummary;
    }

    public PathItem createPathItem(Class<?> clazz, Method aMethod) {
        String path = this.pathExtractor.getMethodPath(clazz, aMethod);
        Operation operation = this.createOperation(path, clazz, aMethod);
        PathItem item = new PathItem();
        item.operation(PathItem.HttpMethod.POST, operation);
        this.additionalParameters.getPathParameters(path, clazz, aMethod).forEach(arg_0 -> ((PathItem)item).addParametersItem(arg_0));
        return item;
    }

    @Nonnull
    private Operation createOperation(String aPath, Class<?> clazz, Method aMethod) {
        Operation operation = new Operation();
        operation.addTagsItem(this.serviceTagExtractor.getServiceTag(clazz).orElse(clazz.getSimpleName()));
        MethodParameters parameters = this.getParameters(aMethod);
        if (parameters.hasParameters()) {
            operation.requestBody(this.createRequestBody(parameters, aPath, clazz, aMethod));
        }
        operation.responses(this.createResponse(aPath, clazz, aMethod));
        operation.summary(this.operationSummary.getOperationSummary(aPath, clazz, aMethod).orElse(aMethod.getName()));
        this.securityItemExtractor.getSecurityItem(clazz, aMethod).ifPresent(arg_0 -> ((Operation)operation).addSecurityItem(arg_0));
        this.operationDescriptionExtractor.getOperationDescription(aPath, clazz, aMethod).ifPresent(arg_0 -> ((Operation)operation).description(arg_0));
        return operation;
    }

    private ApiResponses createResponse(String aPath, Class<?> aClass, Method aMethod) {
        Schema<?> schema = Void.TYPE.equals(aMethod.getReturnType()) ? null : SwaggerSchemas.createSchema(aMethod.getReturnType(), aMethod.getGenericReturnType(), "Return for " + aClass.getSimpleName() + "." + aMethod.getName() + "()");
        MediaType successMediaType = new MediaType().schema(schema);
        List<String> responseExamples = this.responseExamples.getResponseExamples(aPath, aClass, aMethod);
        for (String responseExample : responseExamples) {
            successMediaType.addExamples(responseExample, new Example().$ref("#/components/examples/" + aClass.getSimpleName() + "." + aMethod.getName() + ".Response." + responseExample));
        }
        ApiResponses responses = new ApiResponses().addApiResponse("200", new ApiResponse().description("Success response").content(new Content().addMediaType("application/json", successMediaType)));
        this.errorResponsesExtractor.getErrorResponse(aPath, aClass, aMethod).forEach(error -> responses.addApiResponse(error.getName(), new ApiResponse().description(error.getDescription()).content(this.errorJson(error.getResponseClass()))));
        return responses;
    }

    private Content errorJson(Class<?> aClass) {
        return new Content().addMediaType("application/json; charset=utf-8", new MediaType().schema(SwaggerSchemas.createSchema(aClass, "Error class " + aClass.getSimpleName())));
    }

    private RequestBody createRequestBody(MethodParameters aParameters, String aPath, Class<?> aClass, Method aMethod) {
        if (!aParameters.hasParameters()) {
            throw new IllegalStateException("No any parameters");
        }
        if (aParameters.getParameters().size() == 1) {
            MethodParameter methodParameter = aParameters.getParameters().get(0);
            Class<?> oneArgument = methodParameter.getType();
            MediaType mediaType = new MediaType();
            for (String requestExample : this.requestExample.getRequestExamples(aPath, aClass, aMethod)) {
                mediaType.addExamples(requestExample, new Example().$ref("#/components/examples/" + aClass.getSimpleName() + "." + aMethod.getName() + ".Request." + requestExample));
            }
            return new RequestBody().content(new Content().addMediaType("application/json", mediaType.schema(SwaggerSchemas.createSchema(oneArgument, "One argument for method ").description(methodParameter.getName()))));
        }
        return null;
    }

    @Nonnull
    private MethodParameters getParameters(Method aMethod) {
        ArrayList<MethodParameter> args = new ArrayList<MethodParameter>();
        Parameter[] parameters = aMethod.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            args.add(MethodParameter.builder().typeName(parameter.getType().getSimpleName()).type(parameter.getType()).index(i).name(parameter.getName()).build());
        }
        return new MethodParameters(args);
    }
}

