/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.apigen.swagger;

import com.payneteasy.apigen.core.util.Methods;
import com.payneteasy.apigen.swagger.SwaggerBuilderStrategy;
import com.payneteasy.apigen.swagger.impl.SwaggerMethodComponents;
import com.payneteasy.apigen.swagger.impl.SwaggerMethodPathItem;
import com.payneteasy.apigen.swagger.impl.sorted.SortedPaths;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.tags.Tag;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwaggerBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(SwaggerBuilder.class);
    private final OpenAPI api;
    private final List<Class<?>> interfaces;
    private final SwaggerBuilderStrategy.IPathExtractor methodPathExtractor;
    private final SwaggerMethodPathItem swaggerMethodPathItem;
    private final List<Class<?>> errorClasses;
    private final SwaggerBuilderStrategy.IMethodAcceptor methodAcceptor;
    private final SwaggerBuilderStrategy.IServiceDescriptionExtractor serviceDescription;
    private final SwaggerBuilderStrategy.IServiceTagExtractor serviceTag;
    private final SwaggerBuilderStrategy.IServiceAddListener serviceAddListener;

    public SwaggerBuilder(@Nonnull OpenAPI openApi, @Nonnull SwaggerBuilderStrategy.IMethodAcceptor methodAcceptor, @Nonnull List<Class<?>> interfaces, @Nonnull SwaggerBuilderStrategy.IPathExtractor methodPathExtractor, @Nonnull SwaggerBuilderStrategy.ISecurityItemExtractor securityItemExtractor, @Nonnull SwaggerBuilderStrategy.IServiceDescriptionExtractor serviceDescriptionExtractor, @Nonnull SwaggerBuilderStrategy.IServiceTagExtractor serviceTagExtractor, @Nonnull SwaggerBuilderStrategy.IOperationSummary operationSummary, @Nonnull SwaggerBuilderStrategy.IOperationDescriptionExtractor operationDescriptionExtractor, @Nonnull SwaggerBuilderStrategy.IPathParameters additionalParameters, @Nonnull List<Class<?>> errorClasses, @Nonnull SwaggerBuilderStrategy.IErrorResponsesExtractor errorResponsesExtractor, @Nonnull SwaggerBuilderStrategy.IServiceAddListener serviceAddListener, @Nonnull SwaggerBuilderStrategy.IRequestExamples requestExamples, @Nonnull SwaggerBuilderStrategy.IResponseExamples responseExamples) {
        this.interfaces = SwaggerBuilder.createSortedArray(interfaces);
        this.api = SwaggerBuilder.def(openApi, new OpenAPI());
        this.methodPathExtractor = SwaggerBuilder.def(methodPathExtractor, (aClass, aMethod) -> "/api/" + aClass.getSimpleName() + "/" + aMethod.getName());
        this.errorClasses = SwaggerBuilder.def(errorClasses, Collections.emptyList());
        this.methodAcceptor = SwaggerBuilder.def(methodAcceptor, (clazz, aMethod) -> true);
        this.serviceDescription = SwaggerBuilder.def(serviceDescriptionExtractor, aClass -> Optional.empty());
        this.serviceTag = SwaggerBuilder.def(serviceTagExtractor, aClass -> Optional.empty());
        this.serviceAddListener = SwaggerBuilder.def(serviceAddListener, (aPaths, aClass) -> {});
        this.swaggerMethodPathItem = new SwaggerMethodPathItem(SwaggerBuilder.def(operationDescriptionExtractor, (aPath, aClass, aMethod) -> Optional.empty()), this.methodPathExtractor, SwaggerBuilder.def(securityItemExtractor, (aClass, aMethod) -> Optional.empty()), SwaggerBuilder.def(additionalParameters, (path, clazz, aMethod) -> Collections.emptyList()), SwaggerBuilder.def(errorResponsesExtractor, (aPath, aClass, aMethod) -> Collections.emptyList()), SwaggerBuilder.def(requestExamples, (aPath, aClass, aMethod) -> Collections.emptyList()), SwaggerBuilder.def(responseExamples, (aPath, aClass, aMethod) -> Collections.emptyList()), this.serviceTag, SwaggerBuilder.def(operationSummary, (aPath, aClass, aMethod) -> Optional.empty()));
    }

    private static <T> T def(T aValue, T aDefault) {
        return aValue != null ? aValue : aDefault;
    }

    private static List<Class<?>> createSortedArray(List<Class<?>> aInterfaces) {
        if (aInterfaces == null) {
            throw new IllegalStateException("No any interfaces provided. Did you fill interfaces() method or interfaces parameter?  ");
        }
        ArrayList classes = new ArrayList(aInterfaces);
        classes.sort(Comparator.comparing(Class::getSimpleName));
        return classes;
    }

    public OpenAPI buildOpenApiModel() {
        this.api.tags(this.getTags(this.interfaces)).paths(this.createPaths(this.interfaces)).setComponents(new SwaggerMethodComponents(this.errorClasses, this.methodAcceptor).createComponents(this.interfaces));
        return this.api;
    }

    private Paths createPaths(List<Class<?>> aInterfaces) {
        SortedPaths paths = new SortedPaths();
        for (Class<?> clazz : aInterfaces) {
            this.serviceAddListener.onServiceAdd(paths, clazz);
            for (Method method : Methods.getAllMethods(clazz)) {
                if (!this.methodAcceptor.isMethodAccepted(clazz, method)) continue;
                try {
                    paths.addPathItem(this.methodPathExtractor.getMethodPath(clazz, method), this.swaggerMethodPathItem.createPathItem(clazz, method));
                }
                catch (Exception e) {
                    LOG.error("Cannot create path items for method {}.{}()", new Object[]{clazz.getSimpleName(), method.getName(), e});
                }
            }
        }
        return paths;
    }

    private PathItem createOverviewPathItem(Class<?> aClass) {
        Operation operation = new Operation();
        operation.addTagsItem(aClass.getSimpleName());
        operation.summary("Overview");
        this.serviceDescription.getServiceDescription(aClass).ifPresent(arg_0 -> ((Operation)operation).description(arg_0));
        PathItem item = new PathItem();
        item.operation(PathItem.HttpMethod.HEAD, operation);
        return item;
    }

    private List<Tag> getTags(List<Class<?>> aInterfaces) {
        return aInterfaces.stream().map(trait -> new Tag().name(this.serviceTag.getServiceTag((Class<?>)trait).orElse(trait.getSimpleName())).description(this.serviceDescription.getServiceDescription((Class<?>)trait).orElse(trait.getSimpleName()))).collect(Collectors.toList());
    }

    public static SwaggerBuilderBuilder builder() {
        return new SwaggerBuilderBuilder();
    }

    public static class SwaggerBuilderBuilder {
        private OpenAPI openApi;
        private SwaggerBuilderStrategy.IMethodAcceptor methodAcceptor;
        private List<Class<?>> interfaces;
        private SwaggerBuilderStrategy.IPathExtractor methodPathExtractor;
        private SwaggerBuilderStrategy.ISecurityItemExtractor securityItemExtractor;
        private SwaggerBuilderStrategy.IServiceDescriptionExtractor serviceDescriptionExtractor;
        private SwaggerBuilderStrategy.IServiceTagExtractor serviceTagExtractor;
        private SwaggerBuilderStrategy.IOperationSummary operationSummary;
        private SwaggerBuilderStrategy.IOperationDescriptionExtractor operationDescriptionExtractor;
        private SwaggerBuilderStrategy.IPathParameters additionalParameters;
        private List<Class<?>> errorClasses;
        private SwaggerBuilderStrategy.IErrorResponsesExtractor errorResponsesExtractor;
        private SwaggerBuilderStrategy.IServiceAddListener serviceAddListener;
        private SwaggerBuilderStrategy.IRequestExamples requestExamples;
        private SwaggerBuilderStrategy.IResponseExamples responseExamples;

        SwaggerBuilderBuilder() {
        }

        public SwaggerBuilderBuilder openApi(@Nonnull OpenAPI openApi) {
            this.openApi = openApi;
            return this;
        }

        public SwaggerBuilderBuilder methodAcceptor(@Nonnull SwaggerBuilderStrategy.IMethodAcceptor methodAcceptor) {
            this.methodAcceptor = methodAcceptor;
            return this;
        }

        public SwaggerBuilderBuilder interfaces(@Nonnull List<Class<?>> interfaces) {
            this.interfaces = interfaces;
            return this;
        }

        public SwaggerBuilderBuilder methodPathExtractor(@Nonnull SwaggerBuilderStrategy.IPathExtractor methodPathExtractor) {
            this.methodPathExtractor = methodPathExtractor;
            return this;
        }

        public SwaggerBuilderBuilder securityItemExtractor(@Nonnull SwaggerBuilderStrategy.ISecurityItemExtractor securityItemExtractor) {
            this.securityItemExtractor = securityItemExtractor;
            return this;
        }

        public SwaggerBuilderBuilder serviceDescriptionExtractor(@Nonnull SwaggerBuilderStrategy.IServiceDescriptionExtractor serviceDescriptionExtractor) {
            this.serviceDescriptionExtractor = serviceDescriptionExtractor;
            return this;
        }

        public SwaggerBuilderBuilder serviceTagExtractor(@Nonnull SwaggerBuilderStrategy.IServiceTagExtractor serviceTagExtractor) {
            this.serviceTagExtractor = serviceTagExtractor;
            return this;
        }

        public SwaggerBuilderBuilder operationSummary(@Nonnull SwaggerBuilderStrategy.IOperationSummary operationSummary) {
            this.operationSummary = operationSummary;
            return this;
        }

        public SwaggerBuilderBuilder operationDescriptionExtractor(@Nonnull SwaggerBuilderStrategy.IOperationDescriptionExtractor operationDescriptionExtractor) {
            this.operationDescriptionExtractor = operationDescriptionExtractor;
            return this;
        }

        public SwaggerBuilderBuilder additionalParameters(@Nonnull SwaggerBuilderStrategy.IPathParameters additionalParameters) {
            this.additionalParameters = additionalParameters;
            return this;
        }

        public SwaggerBuilderBuilder errorClasses(@Nonnull List<Class<?>> errorClasses) {
            this.errorClasses = errorClasses;
            return this;
        }

        public SwaggerBuilderBuilder errorResponsesExtractor(@Nonnull SwaggerBuilderStrategy.IErrorResponsesExtractor errorResponsesExtractor) {
            this.errorResponsesExtractor = errorResponsesExtractor;
            return this;
        }

        public SwaggerBuilderBuilder serviceAddListener(@Nonnull SwaggerBuilderStrategy.IServiceAddListener serviceAddListener) {
            this.serviceAddListener = serviceAddListener;
            return this;
        }

        public SwaggerBuilderBuilder requestExamples(@Nonnull SwaggerBuilderStrategy.IRequestExamples requestExamples) {
            this.requestExamples = requestExamples;
            return this;
        }

        public SwaggerBuilderBuilder responseExamples(@Nonnull SwaggerBuilderStrategy.IResponseExamples responseExamples) {
            this.responseExamples = responseExamples;
            return this;
        }

        public SwaggerBuilder build() {
            return new SwaggerBuilder(this.openApi, this.methodAcceptor, this.interfaces, this.methodPathExtractor, this.securityItemExtractor, this.serviceDescriptionExtractor, this.serviceTagExtractor, this.operationSummary, this.operationDescriptionExtractor, this.additionalParameters, this.errorClasses, this.errorResponsesExtractor, this.serviceAddListener, this.requestExamples, this.responseExamples);
        }

        public String toString() {
            return "SwaggerBuilder.SwaggerBuilderBuilder(openApi=" + this.openApi + ", methodAcceptor=" + this.methodAcceptor + ", interfaces=" + this.interfaces + ", methodPathExtractor=" + this.methodPathExtractor + ", securityItemExtractor=" + this.securityItemExtractor + ", serviceDescriptionExtractor=" + this.serviceDescriptionExtractor + ", serviceTagExtractor=" + this.serviceTagExtractor + ", operationSummary=" + this.operationSummary + ", operationDescriptionExtractor=" + this.operationDescriptionExtractor + ", additionalParameters=" + this.additionalParameters + ", errorClasses=" + this.errorClasses + ", errorResponsesExtractor=" + this.errorResponsesExtractor + ", serviceAddListener=" + this.serviceAddListener + ", requestExamples=" + this.requestExamples + ", responseExamples=" + this.responseExamples + ")";
        }
    }
}

