/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.apigen.swagger.impl;

import com.payneteasy.apigen.swagger.SwaggerBuilderStrategy;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class MarkdownHeaders
implements SwaggerBuilderStrategy.IOperationDescriptionExtractor {
    private final Map<String, String> map;

    public MarkdownHeaders(File aFile) {
        this.map = MarkdownHeaders.parseHeaders(aFile);
    }

    private static Map<String, String> parseHeaders(File aFile) {
        HashMap<String, String> map = new HashMap<String, String>();
        try (LineNumberReader in = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(aFile), StandardCharsets.UTF_8));){
            String line;
            StringBuilder pendingContent = new StringBuilder();
            String pendingHeader = null;
            while ((line = in.readLine()) != null) {
                if (line.startsWith("## ") | line.startsWith("### ")) {
                    MarkdownHeaders.addPendings(map, pendingHeader, pendingContent);
                    pendingHeader = line.substring(line.indexOf(32)).trim();
                    continue;
                }
                pendingContent.append(line);
                pendingContent.append('\n');
            }
            MarkdownHeaders.addPendings(map, pendingHeader, pendingContent);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot read " + aFile.getAbsolutePath(), e);
        }
        return map;
    }

    private static void addPendings(Map<String, String> map, String pendingHeader, StringBuilder pendingContent) {
        if (pendingHeader == null) {
            return;
        }
        map.put(pendingHeader, pendingContent.toString());
        pendingContent.delete(0, pendingContent.length());
    }

    @Override
    public Optional<String> getOperationDescription(String aPath, Class<?> aClass, Method aMethod) {
        return Optional.ofNullable(this.map.get(aPath));
    }
}

