/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.apigen.core.util.introspection;

import com.payneteasy.apigen.core.util.Fields;
import com.payneteasy.apigen.core.util.introspection.ParametrizedType;
import com.payneteasy.apigen.core.util.introspection.PropertyName;
import com.payneteasy.apigen.core.util.introspection.PropertyType;
import java.lang.reflect.Field;
import java.util.List;
import java.util.stream.Collectors;

public class PropertyInfo
implements Comparable<PropertyInfo> {
    private final PropertyName propertyName;
    private final Class<?> clazz;
    private final ParametrizedType parametrizedType;

    public PropertyInfo(PropertyName aName, Class<?> aClazz, ParametrizedType aParametrizedType) {
        this.propertyName = aName;
        this.clazz = aClazz;
        this.parametrizedType = aParametrizedType;
    }

    public List<PropertyInfo> getProperties() {
        if (this.getPropertyType() != PropertyType.OBJECT) {
            throw new IllegalStateException("Clazz should be OBJECT but was " + (Object)((Object)this.getPropertyType()));
        }
        return Fields.getAllFields(this.clazz).stream().map(PropertyInfo::propertyFromField).collect(Collectors.toList());
    }

    private static PropertyInfo propertyFromField(Field aField) {
        return new PropertyInfo(PropertyName.createNamed(aField.getName()), aField.getType(), ParametrizedType.paraTypeFromField(aField));
    }

    public PropertyType getPropertyType() {
        return PropertyType.OBJECT;
    }

    @Override
    public int compareTo(PropertyInfo aAnother) {
        return this.propertyName.getPropertyName().compareTo(aAnother.getName().getPropertyName());
    }

    public PropertyName getName() {
        return this.propertyName;
    }
}

